<?php

namespace Drupal\Tests\bamboo_twig\Functional;

/**
 * Tests Config twig filters and functions.
 *
 * @group bamboo_twig
 * @group bamboo_twig_functional
 * @group bamboo_twig_config
 */
class BambooTwigConfigTest extends BambooTwigTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'bamboo_twig',
    'bamboo_twig_config',
    'bamboo_twig_test',
  ];

  /**
   * Salt used in our tests for one-time login links, cancel links, ...
   *
   * @var string
   */
  private $hashSalt;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {

    parent::setUp();

    // Used in our tests to retrieve settings.
    $this->hashSalt = $this->container->get('settings')->get('hash_salt');
  }

  /**
   * @covers Drupal\bamboo_twig_config\TwigExtension\Config::getSettings
   */
  public function testGetSettings() {
    $this->drupalGet('/bamboo-twig-config');

    $this->assertSession()->elementExists('css', '.test-configs div.config-settings');
    $this->assertSession()->elementContains('css', '.test-configs div.config-settings', $this->hashSalt);
  }

  /**
   * @covers Drupal\bamboo_twig_config\TwigExtension\Config::getConfig
   */
  public function testGetConfig() {
    $this->drupalGet('/bamboo-twig-config');

    $this->assertSession()->elementExists('css', '.test-configs div.config-system');
    $this->assertSession()->elementContains('css', '.test-configs div.config-system', 'simpletest@example.com');
  }

  /**
   * @covers Drupal\bamboo_twig_config\TwigExtension\Config::getState
   */
  public function testGetState() {
    $now = time();
    /** @var \Drupal\Core\State\State $state */
    $state = $this->container->get('state');
    $state->set('system.cron_last', $now);

    $this->drupalGet('/bamboo-twig-config');

    $this->assertSession()->elementExists('css', '.test-configs div.config-state');
    $this->assertSession()->elementContains('css', '.test-configs div.config-state', $now);
  }

}
