/**
 * color_picker Javascript
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.behaviors.color_element = {
    attach: function (context, settings) {

      var $context = $(context);

      once('colorPicker', '.color-picker input').forEach(element => {
        // hide the input element that holds the selected colour value
        $(element).hide();
        let default_color = $(element).val();
        let $parent = $(element).next();
        // add the swatches to the colour values container
        let color_values = $(element).data('color-values');
        $.each(color_values.split(","), function (index, value) {
          let el = '';
          if (value === default_color) {
            el = '<div class="color-value selected"><div data-swatch-color="' + value + '" style="background-color: ' + value + ';" class="inner"></div></div>';
          } else {
            el = '<div class="color-value"><div data-swatch-color="' + value + '" style="background-color: ' + value + ';" class="inner"></div></div>';
          }
          $parent.append(el);
        });
      });

      once('colorPicker', '.color-value .inner').forEach(element => {
        element.addEventListener('click', e => {
          $(element).parent().addClass('selected').siblings().removeClass('selected');
          let selected_color = $(element).data('swatch-color');
          $(element).parent().parent().parent().find('input').val(selected_color);
        });
      });

    },
  };

})(jQuery, Drupal, once);
