<?php
// phpcs:ignoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 10.2.4 db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();
// Ensure any tables with a serial column with a value of 0 are created as
// expected.
if ($connection->databaseType() === 'mysql') {
  $sql_mode = $connection->query("SELECT @@sql_mode;")->fetchField();
  $connection->query("SET sql_mode = '$sql_mode,NO_AUTO_VALUE_ON_ZERO'");
}

// Update core.extension.
$extensions = $connection->select('config')
  ->fields('config', ['data'])
  ->condition('collection', '')
  ->condition('name', 'core.extension')
  ->execute()
  ->fetchField();
$extensions = \unserialize($extensions);
$extensions['module']['elasticsearch_connector'] = 8000;
$extensions['module']['search_api'] = 8110;
$connection->update('config')
  ->fields([
    'data' => serialize($extensions),
    'collection' => '',
    'name' => 'core.extension',
  ])
  ->condition('collection', '')
  ->condition('name', 'core.extension')
  ->execute();


$connection->insert('config')
->fields(array(
  'collection',
  'name',
  'data',
))
->values(array(
  'collection' => '',
  'name' => 'elasticsearch_connector.cluster.abrupt_strawberry',
  'data' => 'a:8:{s:4:"uuid";s:36:"14a14a4d-7690-4bb4-9a68-5cac18c86bf9";s:8:"langcode";s:2:"en";s:6:"status";s:1:"1";s:12:"dependencies";a:0:{}s:10:"cluster_id";s:17:"abrupt_strawberry";s:4:"name";s:17:"Abrupt strawberry";s:3:"url";s:43:"http://elasticsearch:9200/abrupt_strawberry";s:7:"options";a:7:{s:25:"multiple_nodes_connection";b:1;s:18:"use_authentication";b:1;s:19:"authentication_type";s:5:"Basic";s:8:"username";s:5:"green";s:8:"password";s:5:"laugh";s:7:"timeout";i:3;s:7:"rewrite";a:2:{s:13:"rewrite_index";b:1;s:5:"index";a:2:{s:6:"prefix";s:6:"brainy";s:6:"suffix";s:0:"";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'elasticsearch_connector.cluster.acceptable_blueberry',
  'data' => 'a:8:{s:4:"uuid";s:36:"5b738a25-ac76-4fdd-923d-0af6632edc49";s:8:"langcode";s:2:"en";s:6:"status";s:1:"1";s:12:"dependencies";a:0:{}s:10:"cluster_id";s:20:"acceptable_blueberry";s:4:"name";s:20:"Acceptable blueberry";s:3:"url";s:46:"http://elasticsearch:9200/acceptable_blueberry";s:7:"options";a:7:{s:25:"multiple_nodes_connection";b:0;s:18:"use_authentication";b:1;s:19:"authentication_type";s:6:"Digest";s:8:"username";s:6:"grumpy";s:8:"password";s:6:"orange";s:7:"timeout";i:3;s:7:"rewrite";a:2:{s:13:"rewrite_index";b:0;s:5:"index";a:2:{s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'elasticsearch_connector.cluster.best_kiwi',
  'data' => 'a:8:{s:4:"uuid";s:36:"553bc925-dba0-4171-bba8-eb591615fb0a";s:8:"langcode";s:2:"en";s:6:"status";s:1:"0";s:12:"dependencies";a:0:{}s:10:"cluster_id";s:9:"best_kiwi";s:4:"name";s:9:"Best kiwi";s:3:"url";s:35:"http://elasticsearch:9200/best_kiwi";s:7:"options";a:7:{s:25:"multiple_nodes_connection";b:0;s:18:"use_authentication";b:0;s:19:"authentication_type";s:5:"Basic";s:8:"username";s:0:"";s:8:"password";s:0:"";s:7:"timeout";i:3;s:7:"rewrite";a:2:{s:13:"rewrite_index";b:0;s:5:"index";a:2:{s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'elasticsearch_connector.cluster.bustling_grapefruit',
  'data' => 'a:8:{s:4:"uuid";s:36:"1740f8bc-df4c-4308-91d4-aed66f910114";s:8:"langcode";s:2:"en";s:6:"status";s:1:"1";s:12:"dependencies";a:0:{}s:10:"cluster_id";s:19:"bustling_grapefruit";s:4:"name";s:19:"Bustling grapefruit";s:3:"url";s:45:"http://elasticsearch:9200/bustling_grapefruit";s:7:"options";a:7:{s:25:"multiple_nodes_connection";b:0;s:18:"use_authentication";b:1;s:19:"authentication_type";s:4:"NTLM";s:8:"username";s:8:"gigantic";s:8:"password";s:8:"distance";s:7:"timeout";i:30;s:7:"rewrite";a:2:{s:13:"rewrite_index";b:1;s:5:"index";a:2:{s:6:"prefix";s:0:"";s:6:"suffix";s:7:"parched";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'elasticsearch_connector.cluster.tacky_pear',
  'data' => 'a:8:{s:4:"uuid";s:36:"25be307a-ca68-4bcb-9741-9e429e41be77";s:8:"langcode";s:2:"en";s:6:"status";s:1:"1";s:12:"dependencies";a:0:{}s:10:"cluster_id";s:10:"tacky_pear";s:4:"name";s:10:"Tacky pear";s:3:"url";s:36:"http://elasticsearch:9200/tacky_pear";s:7:"options";a:7:{s:25:"multiple_nodes_connection";b:1;s:18:"use_authentication";b:0;s:19:"authentication_type";s:5:"Basic";s:8:"username";s:0:"";s:8:"password";s:0:"";s:7:"timeout";i:3;s:7:"rewrite";a:2:{s:13:"rewrite_index";b:1;s:5:"index";a:2:{s:6:"prefix";s:6:"grumpy";s:6:"suffix";s:5:"raspy";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'elasticsearch_connector.index.educated_buckle',
  'data' => 'a:9:{s:4:"uuid";s:36:"7074e242-38bc-4296-8080-a5c623c6302d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:8:"index_id";s:15:"educated_buckle";s:4:"name";s:15:"Educated buckle";s:13:"num_of_shards";i:2;s:14:"num_of_replica";i:4;s:6:"server";s:10:"tacky_pear";}',
))
->values(array(
  'collection' => '',
  'name' => 'elasticsearch_connector.index.nostalgic_button',
  'data' => 'a:9:{s:4:"uuid";s:36:"32a19e72-cb1f-49ef-803b-634e4b0e341f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:8:"index_id";s:16:"nostalgic_button";s:4:"name";s:16:"Nostalgic button";s:13:"num_of_shards";i:5;s:14:"num_of_replica";i:1;s:6:"server";s:17:"abrupt_strawberry";}',
))
->values(array(
  'collection' => '',
  'name' => 'elasticsearch_connector.index.spurious_zipper',
  'data' => 'a:9:{s:4:"uuid";s:36:"ee7663cc-e210-4e6d-a589-d109ef63213c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:8:"index_id";s:15:"spurious_zipper";s:4:"name";s:15:"Spurious zipper";s:13:"num_of_shards";i:2;s:14:"num_of_replica";i:2;s:6:"server";s:20:"acceptable_blueberry";}',
))
->values(array(
  'collection' => '',
  'name' => 'elasticsearch_connector.index.subdued_hook',
  'data' => 'a:9:{s:4:"uuid";s:36:"3297fdc3-ab0d-426d-bdb8-869ce1524afb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:8:"index_id";s:12:"subdued_hook";s:4:"name";s:12:"Subdued hook";s:13:"num_of_shards";i:5;s:14:"num_of_replica";i:1;s:6:"server";s:19:"bustling_grapefruit";}',
))
->values(array(
  'collection' => '',
  'name' => 'elasticsearch_connector.index.tense_fastener',
  'data' => 'a:9:{s:4:"uuid";s:36:"2b5922a6-b8ff-4254-9bbf-c8d3d647b81b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:8:"index_id";s:14:"tense_fastener";s:4:"name";s:14:"Tense fastener";s:13:"num_of_shards";i:5;s:14:"num_of_replica";i:3;s:6:"server";s:10:"tacky_pear";}',
))
->values(array(
  'collection' => '',
  'name' => 'elasticsearch_connector.index.tremendous_clasp',
  'data' => 'a:9:{s:4:"uuid";s:36:"143dda21-a477-4c0d-afbc-357b73d5dea5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:8:"index_id";s:16:"tremendous_clasp";s:4:"name";s:16:"Tremendous clasp";s:13:"num_of_shards";i:5;s:14:"num_of_replica";i:1;s:6:"server";s:9:"best_kiwi";}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.amazing_clock',
  'data' => 'a:14:{s:4:"uuid";s:36:"fafeab8b-1ec4-4d58-9094-b8834d9327e8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:31:"search_api.server.oval_decision";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:10:"search_api";}}s:2:"id";s:13:"amazing_clock";s:4:"name";s:13:"Amazing clock";s:11:"description";s:19:"Suspendisse semper.";s:9:"read_only";b:0;s:14:"field_settings";a:3:{s:3:"nid";a:5:{s:5:"label";s:2:"ID";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:3:"nid";s:4:"type";s:7:"integer";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:4:"uuid";a:5:{s:5:"label";s:4:"UUID";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:4:"uuid";s:4:"type";s:6:"string";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:3:"vid";a:5:{s:5:"label";s:11:"Revision ID";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:3:"vid";s:4:"type";s:7:"integer";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}}s:19:"datasource_settings";a:1:{s:11:"entity:node";a:2:{s:7:"bundles";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}}}s:18:"processor_settings";a:7:{s:7:"add_url";a:0:{}s:16:"aggregated_field";a:0:{}s:12:"custom_value";a:0:{}s:13:"entity_status";a:0:{}s:11:"entity_type";a:0:{}s:22:"language_with_fallback";a:0:{}s:13:"rendered_item";a:0:{}}s:16:"tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:7:"options";a:3:{s:10:"cron_limit";i:50;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:1;}s:6:"server";s:13:"oval_decision";}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.colorful_organization',
  'data' => 'a:14:{s:4:"uuid";s:36:"6dbc0615-3cfb-41a8-b664-bb39e80502c3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:29:"search_api.server.square_idea";}s:6:"module";a:3:{i:0;s:10:"search_api";i:1;s:4:"node";i:2;s:4:"user";}}s:2:"id";s:21:"colorful_organization";s:4:"name";s:21:"Colorful organization";s:11:"description";s:9:"Arcu sed.";s:9:"read_only";b:0;s:14:"field_settings";a:3:{s:11:"entity_type";a:3:{s:5:"label";s:11:"Entity type";s:13:"property_path";s:22:"search_api_entity_type";s:4:"type";s:6:"string";}s:22:"language_with_fallback";a:3:{s:5:"label";s:24:"Language (with fallback)";s:13:"property_path";s:22:"language_with_fallback";s:4:"type";s:6:"string";}s:13:"rendered_item";a:4:{s:5:"label";s:20:"Rendered HTML output";s:13:"property_path";s:13:"rendered_item";s:4:"type";s:4:"text";s:13:"configuration";a:2:{s:5:"roles";a:1:{i:0;s:9:"anonymous";}s:9:"view_mode";a:2:{s:11:"entity:node";a:2:{s:7:"article";s:0:"";s:4:"page";s:0:"";}s:11:"entity:user";a:1:{s:4:"user";s:0:"";}}}}}s:19:"datasource_settings";a:2:{s:11:"entity:node";a:2:{s:7:"bundles";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}}s:11:"entity:user";a:1:{s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}}}s:18:"processor_settings";a:6:{s:7:"add_url";a:0:{}s:16:"aggregated_field";a:0:{}s:12:"custom_value";a:0:{}s:11:"entity_type";a:0:{}s:22:"language_with_fallback";a:0:{}s:13:"rendered_item";a:0:{}}s:16:"tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:7:"options";a:3:{s:10:"cron_limit";i:50;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:1;}s:6:"server";s:11:"square_idea";}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.drab_feather',
  'data' => 'a:14:{s:4:"uuid";s:36:"b0019425-595a-42c8-b312-62df0e03c676";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:34:"search_api.server.circular_opinion";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:10:"search_api";}}s:2:"id";s:12:"drab_feather";s:4:"name";s:12:"Drab feather";s:11:"description";s:15:"Eget efficitur.";s:9:"read_only";b:0;s:14:"field_settings";a:7:{s:12:"custom_value";a:4:{s:5:"label";s:12:"Custom value";s:13:"property_path";s:12:"custom_value";s:4:"type";s:6:"string";s:13:"configuration";a:1:{s:5:"value";s:44:"The quick brown fox jumps over the lazy dog.";}}s:6:"format";a:5:{s:5:"label";s:19:"Body » Text format";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:11:"body:format";s:4:"type";s:6:"string";s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:23:"field.storage.node.body";}}}s:3:"nid";a:5:{s:5:"label";s:2:"ID";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:3:"nid";s:4:"type";s:7:"integer";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:11:"node_grants";a:6:{s:5:"label";s:23:"Node access information";s:13:"property_path";s:22:"search_api_node_grants";s:4:"type";s:6:"string";s:14:"indexed_locked";b:1;s:11:"type_locked";b:1;s:6:"hidden";b:1;}s:6:"status";a:7:{s:5:"label";N;s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:6:"status";s:4:"type";s:7:"boolean";s:14:"indexed_locked";b:1;s:11:"type_locked";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:5:"title";a:5:{s:5:"label";s:5:"Title";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:5:"title";s:4:"type";s:6:"string";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:3:"uid";a:7:{s:5:"label";N;s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:3:"uid";s:4:"type";s:7:"integer";s:14:"indexed_locked";b:1;s:11:"type_locked";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}}s:19:"datasource_settings";a:1:{s:11:"entity:node";a:2:{s:7:"bundles";a:2:{s:7:"default";b:1;s:8:"selected";a:1:{i:0;s:7:"article";}}s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:1:{i:0;s:2:"en";}}}}s:18:"processor_settings";a:7:{s:7:"add_url";a:0:{}s:16:"aggregated_field";a:0:{}s:14:"content_access";a:1:{s:7:"weights";a:1:{s:16:"preprocess_query";i:-30;}}s:12:"custom_value";a:0:{}s:11:"entity_type";a:0:{}s:22:"language_with_fallback";a:0:{}s:13:"rendered_item";a:0:{}}s:16:"tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"lifo";}}s:7:"options";a:3:{s:10:"cron_limit";i:25;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:1;}s:6:"server";s:16:"circular_opinion";}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.dramatic_bicycle',
  'data' => 'a:14:{s:4:"uuid";s:36:"daa9aad1-8e8a-4822-8004-881e9a2211b9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:38:"search_api.server.triangular_discovery";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:10:"search_api";}}s:2:"id";s:16:"dramatic_bicycle";s:4:"name";s:16:"Dramatic bicycle";s:11:"description";s:17:"Vestibulum lorem.";s:9:"read_only";b:0;s:14:"field_settings";a:2:{s:5:"title";a:5:{s:5:"label";s:5:"Title";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:5:"title";s:4:"type";s:6:"string";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:7:"title_1";a:5:{s:5:"label";s:5:"Title";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:5:"title";s:4:"type";s:6:"string";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}}s:19:"datasource_settings";a:1:{s:11:"entity:node";a:2:{s:7:"bundles";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}}}s:18:"processor_settings";a:7:{s:7:"add_url";a:0:{}s:16:"aggregated_field";a:0:{}s:12:"custom_value";a:0:{}s:11:"entity_type";a:0:{}s:9:"highlight";a:9:{s:7:"weights";a:1:{s:17:"postprocess_query";i:0;}s:6:"prefix";s:8:"<strong>";s:6:"suffix";s:9:"</strong>";s:7:"excerpt";b:1;s:14:"excerpt_always";b:0;s:14:"excerpt_length";i:256;s:14:"exclude_fields";a:0:{}s:9:"highlight";s:6:"always";s:17:"highlight_partial";b:0;}s:22:"language_with_fallback";a:0:{}s:13:"rendered_item";a:0:{}}s:16:"tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:7:"options";a:3:{s:10:"cron_limit";i:50;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:1;}s:6:"server";s:20:"triangular_discovery";}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.parched_arithmetic',
  'data' => 'a:14:{s:4:"uuid";s:36:"61db8b8c-d661-4313-b040-03684b4428de";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:34:"search_api.server.hexagonal_system";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:10:"search_api";}}s:2:"id";s:18:"parched_arithmetic";s:4:"name";s:18:"Parched arithmetic";s:11:"description";s:22:"Consectetur convallis.";s:9:"read_only";b:0;s:14:"field_settings";a:3:{s:7:"changed";a:5:{s:5:"label";s:7:"Changed";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:7:"changed";s:4:"type";s:4:"date";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:7:"created";a:5:{s:5:"label";s:11:"Authored on";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:7:"created";s:4:"type";s:4:"date";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:18:"revision_timestamp";a:5:{s:5:"label";s:20:"Revision create time";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:18:"revision_timestamp";s:4:"type";s:4:"date";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}}s:19:"datasource_settings";a:1:{s:11:"entity:node";a:2:{s:7:"bundles";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}}}s:18:"processor_settings";a:6:{s:7:"add_url";a:0:{}s:16:"aggregated_field";a:0:{}s:12:"custom_value";a:0:{}s:11:"entity_type";a:0:{}s:22:"language_with_fallback";a:0:{}s:13:"rendered_item";a:0:{}}s:16:"tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:7:"options";a:3:{s:10:"cron_limit";i:50;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:1;}s:6:"server";s:16:"hexagonal_system";}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.robust_discussion',
  'data' => 'a:14:{s:4:"uuid";s:36:"cd6f77d9-28a3-4c26-ac9a-22895090e19f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:34:"search_api.server.octagonal_rhythm";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:10:"search_api";}}s:2:"id";s:17:"robust_discussion";s:4:"name";s:17:"Robust discussion";s:11:"description";s:16:"Vivamus in arcu.";s:9:"read_only";b:0;s:14:"field_settings";a:4:{s:12:"revision_log";a:5:{s:5:"label";s:20:"Revision log message";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:12:"revision_log";s:4:"type";s:4:"text";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:6:"sticky";a:5:{s:5:"label";s:22:"Sticky at top of lists";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:6:"sticky";s:4:"type";s:7:"boolean";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:5:"title";a:5:{s:5:"label";s:5:"Title";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:5:"title";s:4:"type";s:6:"string";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:3:"vid";a:5:{s:5:"label";s:11:"Revision ID";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:3:"vid";s:4:"type";s:7:"integer";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}}s:19:"datasource_settings";a:1:{s:11:"entity:node";a:2:{s:7:"bundles";a:2:{s:7:"default";b:1;s:8:"selected";a:1:{i:0;s:4:"page";}}s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:1:{i:0;s:2:"en";}}}}s:18:"processor_settings";a:8:{s:7:"add_url";a:0:{}s:16:"aggregated_field";a:0:{}s:12:"custom_value";a:0:{}s:11:"entity_type";a:0:{}s:9:"highlight";a:9:{s:7:"weights";a:1:{s:17:"postprocess_query";i:0;}s:6:"prefix";s:8:"<strong>";s:6:"suffix";s:9:"</strong>";s:7:"excerpt";b:1;s:14:"excerpt_always";b:0;s:14:"excerpt_length";i:256;s:14:"exclude_fields";a:0:{}s:9:"highlight";s:6:"always";s:17:"highlight_partial";b:0;}s:22:"language_with_fallback";a:0:{}s:13:"rendered_item";a:0:{}s:10:"type_boost";a:2:{s:7:"weights";a:1:{s:16:"preprocess_index";i:0;}s:6:"boosts";a:1:{s:11:"entity:node";a:1:{s:16:"datasource_boost";d:1;}}}}s:16:"tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:7:"options";a:3:{s:10:"cron_limit";i:50;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:0;}s:6:"server";s:16:"octagonal_rhythm";}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.yummy_lettuce',
  'data' => 'a:14:{s:4:"uuid";s:36:"8e3ef4c9-ca57-4bd8-95a4-2e14e223a59b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:29:"search_api.server.square_idea";}s:6:"module";a:2:{i:0;s:10:"search_api";i:1;s:4:"node";}}s:2:"id";s:13:"yummy_lettuce";s:4:"name";s:13:"Yummy lettuce";s:11:"description";s:14:"Cras volutpat.";s:9:"read_only";b:0;s:14:"field_settings";a:0:{}s:19:"datasource_settings";a:1:{s:11:"entity:node";a:2:{s:7:"bundles";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}}}s:18:"processor_settings";a:7:{s:7:"add_url";a:0:{}s:16:"aggregated_field";a:0:{}s:12:"custom_value";a:0:{}s:11:"entity_type";a:0:{}s:11:"html_filter";a:6:{s:7:"weights";a:2:{s:16:"preprocess_index";i:-15;s:16:"preprocess_query";i:-15;}s:10:"all_fields";b:0;s:6:"fields";a:0:{}s:5:"title";b:1;s:3:"alt";b:1;s:4:"tags";a:7:{s:1:"b";i:2;s:2:"em";i:1;s:2:"h1";i:5;s:2:"h2";i:3;s:2:"h3";i:2;s:6:"strong";i:2;s:1:"u";i:1;}}s:22:"language_with_fallback";a:0:{}s:13:"rendered_item";a:0:{}}s:16:"tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:7:"options";a:3:{s:10:"cron_limit";i:50;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:1;}s:6:"server";s:11:"square_idea";}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.server.circular_opinion',
  'data' => 'a:9:{s:4:"uuid";s:36:"29b155a9-1319-4c32-944a-a245be881eed";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:23:"elasticsearch_connector";}}s:2:"id";s:16:"circular_opinion";s:4:"name";s:16:"Circular opinion";s:11:"description";s:14:"Libero tellus.";s:7:"backend";s:13:"elasticsearch";s:14:"backend_config";a:2:{s:16:"cluster_settings";a:1:{s:7:"cluster";s:10:"tacky_pear";}s:9:"fuzziness";s:1:"5";}}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.server.hexagonal_system',
  'data' => 'a:9:{s:4:"uuid";s:36:"b22f00bf-8c4d-4888-8812-d274a408fdd4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:23:"elasticsearch_connector";}}s:2:"id";s:16:"hexagonal_system";s:4:"name";s:16:"Hexagonal system";s:11:"description";s:16:"Nulla imperdiet.";s:7:"backend";s:13:"elasticsearch";s:14:"backend_config";a:2:{s:16:"cluster_settings";a:1:{s:7:"cluster";s:19:"bustling_grapefruit";}s:9:"fuzziness";s:1:"4";}}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.server.octagonal_rhythm',
  'data' => 'a:9:{s:4:"uuid";s:36:"3be5cea3-1d0e-463d-a376-a367a791d4aa";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:23:"elasticsearch_connector";}}s:2:"id";s:16:"octagonal_rhythm";s:4:"name";s:16:"Octagonal rhythm";s:11:"description";s:16:"Adipiscing elit.";s:7:"backend";s:13:"elasticsearch";s:14:"backend_config";a:2:{s:16:"cluster_settings";a:1:{s:7:"cluster";s:20:"acceptable_blueberry";}s:9:"fuzziness";s:4:"auto";}}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.server.oval_decision',
  'data' => 'a:9:{s:4:"uuid";s:36:"33a4b15a-00cc-4cfe-a30e-17e6c7c56ece";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:23:"elasticsearch_connector";}}s:2:"id";s:13:"oval_decision";s:4:"name";s:13:"Oval decision";s:11:"description";s:12:"Lorem ipsum.";s:7:"backend";s:13:"elasticsearch";s:14:"backend_config";a:3:{s:16:"cluster_settings";a:1:{s:7:"cluster";s:17:"abrupt_strawberry";}s:9:"fuzziness";s:1:"1";s:18:"server_description";s:0:"";}}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.server.square_idea',
  'data' => 'a:9:{s:4:"uuid";s:36:"69cbcf01-100a-4298-8f46-e7206dda69bf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:23:"elasticsearch_connector";}}s:2:"id";s:11:"square_idea";s:4:"name";s:11:"Square idea";s:11:"description";s:10:"Dolor sit.";s:7:"backend";s:13:"elasticsearch";s:14:"backend_config";a:3:{s:16:"cluster_settings";a:1:{s:7:"cluster";s:10:"tacky_pear";}s:9:"fuzziness";s:1:"2";s:18:"server_description";s:0:"";}}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.server.triangular_discovery',
  'data' => 'a:9:{s:4:"uuid";s:36:"b810c9e8-8022-447d-8488-8cacfc0c7012";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:23:"elasticsearch_connector";}}s:2:"id";s:20:"triangular_discovery";s:4:"name";s:20:"Triangular discovery";s:11:"description";s:17:"Amet consectetur.";s:7:"backend";s:13:"elasticsearch";s:14:"backend_config";a:3:{s:16:"cluster_settings";a:1:{s:7:"cluster";s:17:"abrupt_strawberry";}s:9:"fuzziness";s:1:"3";s:18:"server_description";s:0:"";}}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.settings',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"b2zIRm9Jv3SB60NYdZkZHxH8-KdEa-Xa48-4NsIi4lg";}s:18:"default_cron_limit";i:50;s:19:"cron_worker_runtime";i:15;s:15:"default_tracker";s:7:"default";s:18:"tracking_page_size";i:100;s:13:"boost_factors";a:21:{i:0;d:0;i:1;d:0.1;i:2;d:0.2;i:3;d:0.3;i:4;d:0.5;i:5;d:0.6;i:6;d:0.7;i:7;d:0.8;i:8;d:0.9;i:9;d:1;i:10;d:1.1;i:11;d:1.2;i:12;d:1.3;i:13;d:1.4;i:14;d:1.5;i:15;d:2;i:16;d:3;i:17;d:5;i:18;d:8;i:19;d:13;i:20;d:21;}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.elastic_admin',
  'data' => 'a:9:{s:4:"uuid";s:36:"c61ecd62-6967-4995-b1db-8325f29e0993";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:23:"elasticsearch_connector";}}s:2:"id";s:13:"elastic_admin";s:5:"label";s:27:"ElasticSearch administrator";s:6:"weight";i:2;s:8:"is_admin";N;s:11:"permissions";a:3:{i:0;s:32:"administer elasticsearch cluster";i:1;s:34:"administer elasticsearch connector";i:2;s:30:"administer elasticsearch index";}}',
))
->execute();

$connection->insert('key_value')
->fields(array(
  'collection',
  'name',
  'value',
))
->values(array(
  'collection' => 'config.entity.key_store.elasticsearch_cluster',
  'name' => 'uuid:14a14a4d-7690-4bb4-9a68-5cac18c86bf9',
  'value' => 'a:1:{i:0;s:49:"elasticsearch_connector.cluster.abrupt_strawberry";}',
))
->values(array(
  'collection' => 'config.entity.key_store.elasticsearch_cluster',
  'name' => 'uuid:1740f8bc-df4c-4308-91d4-aed66f910114',
  'value' => 'a:1:{i:0;s:51:"elasticsearch_connector.cluster.bustling_grapefruit";}',
))
->values(array(
  'collection' => 'config.entity.key_store.elasticsearch_cluster',
  'name' => 'uuid:25be307a-ca68-4bcb-9741-9e429e41be77',
  'value' => 'a:1:{i:0;s:42:"elasticsearch_connector.cluster.tacky_pear";}',
))
->values(array(
  'collection' => 'config.entity.key_store.elasticsearch_cluster',
  'name' => 'uuid:553bc925-dba0-4171-bba8-eb591615fb0a',
  'value' => 'a:1:{i:0;s:41:"elasticsearch_connector.cluster.best_kiwi";}',
))
->values(array(
  'collection' => 'config.entity.key_store.elasticsearch_cluster',
  'name' => 'uuid:5b738a25-ac76-4fdd-923d-0af6632edc49',
  'value' => 'a:1:{i:0;s:52:"elasticsearch_connector.cluster.acceptable_blueberry";}',
))
->values(array(
  'collection' => 'config.entity.key_store.elasticsearch_index',
  'name' => 'uuid:143dda21-a477-4c0d-afbc-357b73d5dea5',
  'value' => 'a:1:{i:0;s:46:"elasticsearch_connector.index.tremendous_clasp";}',
))
->values(array(
  'collection' => 'config.entity.key_store.elasticsearch_index',
  'name' => 'uuid:2b5922a6-b8ff-4254-9bbf-c8d3d647b81b',
  'value' => 'a:1:{i:0;s:44:"elasticsearch_connector.index.tense_fastener";}',
))
->values(array(
  'collection' => 'config.entity.key_store.elasticsearch_index',
  'name' => 'uuid:3297fdc3-ab0d-426d-bdb8-869ce1524afb',
  'value' => 'a:1:{i:0;s:42:"elasticsearch_connector.index.subdued_hook";}',
))
->values(array(
  'collection' => 'config.entity.key_store.elasticsearch_index',
  'name' => 'uuid:32a19e72-cb1f-49ef-803b-634e4b0e341f',
  'value' => 'a:1:{i:0;s:46:"elasticsearch_connector.index.nostalgic_button";}',
))
->values(array(
  'collection' => 'config.entity.key_store.elasticsearch_index',
  'name' => 'uuid:7074e242-38bc-4296-8080-a5c623c6302d',
  'value' => 'a:1:{i:0;s:45:"elasticsearch_connector.index.educated_buckle";}',
))
->values(array(
  'collection' => 'config.entity.key_store.elasticsearch_index',
  'name' => 'uuid:ee7663cc-e210-4e6d-a589-d109ef63213c',
  'value' => 'a:1:{i:0;s:45:"elasticsearch_connector.index.spurious_zipper";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:61db8b8c-d661-4313-b040-03684b4428de',
  'value' => 'a:1:{i:0;s:35:"search_api.index.parched_arithmetic";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:6dbc0615-3cfb-41a8-b664-bb39e80502c3',
  'value' => 'a:1:{i:0;s:38:"search_api.index.colorful_organization";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:8e3ef4c9-ca57-4bd8-95a4-2e14e223a59b',
  'value' => 'a:1:{i:0;s:30:"search_api.index.yummy_lettuce";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:b0019425-595a-42c8-b312-62df0e03c676',
  'value' => 'a:1:{i:0;s:29:"search_api.index.drab_feather";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:cd6f77d9-28a3-4c26-ac9a-22895090e19f',
  'value' => 'a:1:{i:0;s:34:"search_api.index.robust_discussion";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:daa9aad1-8e8a-4822-8004-881e9a2211b9',
  'value' => 'a:1:{i:0;s:33:"search_api.index.dramatic_bicycle";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:fafeab8b-1ec4-4d58-9094-b8834d9327e8',
  'value' => 'a:1:{i:0;s:30:"search_api.index.amazing_clock";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_server',
  'name' => 'uuid:29b155a9-1319-4c32-944a-a245be881eed',
  'value' => 'a:1:{i:0;s:34:"search_api.server.circular_opinion";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_server',
  'name' => 'uuid:33a4b15a-00cc-4cfe-a30e-17e6c7c56ece',
  'value' => 'a:1:{i:0;s:31:"search_api.server.oval_decision";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_server',
  'name' => 'uuid:3be5cea3-1d0e-463d-a376-a367a791d4aa',
  'value' => 'a:1:{i:0;s:34:"search_api.server.octagonal_rhythm";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_server',
  'name' => 'uuid:69cbcf01-100a-4298-8f46-e7206dda69bf',
  'value' => 'a:1:{i:0;s:29:"search_api.server.square_idea";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_server',
  'name' => 'uuid:b22f00bf-8c4d-4888-8812-d274a408fdd4',
  'value' => 'a:1:{i:0;s:34:"search_api.server.hexagonal_system";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_server',
  'name' => 'uuid:b810c9e8-8022-447d-8488-8cacfc0c7012',
  'value' => 'a:1:{i:0;s:38:"search_api.server.triangular_discovery";}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'elasticsearch_cluster.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:21:"elasticsearch_cluster";s:8:" * class";s:45:"Drupal\elasticsearch_connector\Entity\Cluster";s:11:" * provider";s:23:"elasticsearch_connector";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:11:{s:2:"id";s:10:"cluster_id";s:5:"label";s:4:"name";s:6:"status";s:6:"status";s:3:"url";s:3:"url";s:7:"options";s:7:"options";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:45:"Drupal\elasticsearch_connector\Entity\Cluster";s:11:" * handlers";a:5:{s:12:"list_builder";s:60:"Drupal\elasticsearch_connector\Controller\ClusterListBuilder";s:4:"form";a:2:{s:7:"default";s:47:"Drupal\elasticsearch_connector\Form\ClusterForm";s:6:"delete";s:53:"Drupal\elasticsearch_connector\Form\ClusterDeleteForm";}s:14:"route_provider";a:1:{s:4:"html";s:58:"Drupal\elasticsearch_connector\Entity\ClusterRouteProvider";}s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:32:"administer elasticsearch cluster";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:21:"Elasticsearch Cluster";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";s:0:"";s:15:" * label_plural";s:0:"";s:14:" * label_count";a:0:{}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:33:"config:elasticsearch_cluster_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:7:"cluster";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:5:{i:0;s:10:"cluster_id";i:1;s:4:"name";i:2;s:6:"status";i:3;s:3:"url";i:4;s:7:"options";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'elasticsearch_index.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:19:"elasticsearch_index";s:8:" * class";s:43:"Drupal\elasticsearch_connector\Entity\Index";s:11:" * provider";s:23:"elasticsearch_connector";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:11:{s:2:"id";s:8:"index_id";s:5:"label";s:4:"name";s:13:"num_of_shards";s:13:"num_of_shards";s:14:"num_of_replica";s:14:"num_of_replica";s:6:"server";s:6:"server";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:43:"Drupal\elasticsearch_connector\Entity\Index";s:11:" * handlers";a:4:{s:4:"form";a:2:{s:7:"default";s:45:"Drupal\elasticsearch_connector\Form\IndexForm";s:6:"delete";s:51:"Drupal\elasticsearch_connector\Form\IndexDeleteForm";}s:14:"route_provider";a:1:{s:4:"html";s:56:"Drupal\elasticsearch_connector\Entity\IndexRouteProvider";}s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:30:"administer elasticsearch index";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Elasticsearch Index";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";s:0:"";s:15:" * label_plural";s:0:"";s:14:" * label_count";a:0:{}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:31:"config:elasticsearch_index_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:5:"index";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:5:{i:0;s:8:"index_id";i:1;s:4:"name";i:2;s:13:"num_of_shards";i:3;s:14:"num_of_replica";i:4;s:6:"server";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'search_api_index.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:16:"search_api_index";s:8:" * class";s:30:"Drupal\search_api\Entity\Index";s:11:" * provider";s:10:"search_api";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:4:"name";s:4:"uuid";s:4:"uuid";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:" * originalClass";s:30:"Drupal\search_api\Entity\Index";s:11:" * handlers";a:4:{s:7:"storage";s:53:"Drupal\search_api\Entity\SearchApiConfigEntityStorage";s:12:"list_builder";s:34:"Drupal\search_api\IndexListBuilder";s:4:"form";a:12:{s:7:"default";s:32:"Drupal\search_api\Form\IndexForm";s:4:"edit";s:32:"Drupal\search_api\Form\IndexForm";s:6:"fields";s:38:"Drupal\search_api\Form\IndexFieldsForm";s:10:"add_fields";s:41:"Drupal\search_api\Form\IndexAddFieldsForm";s:12:"field_config";s:45:"Drupal\search_api\Form\FieldConfigurationForm";s:10:"break_lock";s:41:"Drupal\search_api\Form\IndexBreakLockForm";s:10:"processors";s:42:"Drupal\search_api\Form\IndexProcessorsForm";s:6:"delete";s:45:"Drupal\search_api\Form\IndexDeleteConfirmForm";s:7:"disable";s:46:"Drupal\search_api\Form\IndexDisableConfirmForm";s:7:"reindex";s:46:"Drupal\search_api\Form\IndexReindexConfirmForm";s:5:"clear";s:44:"Drupal\search_api\Form\IndexClearConfirmForm";s:15:"rebuild_tracker";s:53:"Drupal\search_api\Form\IndexRebuildTrackerConfirmForm";}s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";}s:19:" * admin_permission";s:21:"administer search_api";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:11:{s:9:"canonical";s:56:"/admin/config/search/search-api/index/{search_api_index}";s:8:"add-form";s:41:"/admin/config/search/search-api/add-index";s:9:"edit-form";s:61:"/admin/config/search/search-api/index/{search_api_index}/edit";s:6:"fields";s:63:"/admin/config/search/search-api/index/{search_api_index}/fields";s:10:"add-fields";s:72:"/admin/config/search/search-api/index/{search_api_index}/fields/add/nojs";s:15:"add-fields-ajax";s:72:"/admin/config/search/search-api/index/{search_api_index}/fields/add/ajax";s:15:"break-lock-form";s:74:"/admin/config/search/search-api/index/{search_api_index}/fields/break-lock";s:10:"processors";s:67:"/admin/config/search/search-api/index/{search_api_index}/processors";s:11:"delete-form";s:63:"/admin/config/search/search-api/index/{search_api_index}/delete";s:7:"disable";s:64:"/admin/config/search/search-api/index/{search_api_index}/disable";s:6:"enable";s:63:"/admin/config/search/search-api/index/{search_api_index}/enable";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Search index";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"Search indexes";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"search index";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"search indexes";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:19:"@count search index";s:6:"plural";s:21:"@count search indexes";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:28:"config:search_api_index_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:5:"index";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:10:{i:0;s:2:"id";i:1;s:4:"name";i:2;s:11:"description";i:3;s:9:"read_only";i:4;s:14:"field_settings";i:5;s:19:"datasource_settings";i:6;s:18:"processor_settings";i:7;s:16:"tracker_settings";i:8;s:7:"options";i:9;s:6:"server";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'search_api_server.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:17:"search_api_server";s:8:" * class";s:31:"Drupal\search_api\Entity\Server";s:11:" * provider";s:10:"search_api";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:4:"name";s:4:"uuid";s:4:"uuid";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:" * originalClass";s:31:"Drupal\search_api\Entity\Server";s:11:" * handlers";a:3:{s:7:"storage";s:53:"Drupal\search_api\Entity\SearchApiConfigEntityStorage";s:4:"form";a:5:{s:7:"default";s:33:"Drupal\search_api\Form\ServerForm";s:4:"edit";s:33:"Drupal\search_api\Form\ServerForm";s:6:"delete";s:46:"Drupal\search_api\Form\ServerDeleteConfirmForm";s:7:"disable";s:47:"Drupal\search_api\Form\ServerDisableConfirmForm";s:5:"clear";s:45:"Drupal\search_api\Form\ServerClearConfirmForm";}s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";}s:19:" * admin_permission";s:21:"administer search_api";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:6:{s:9:"canonical";s:58:"/admin/config/search/search-api/server/{search_api_server}";s:8:"add-form";s:42:"/admin/config/search/search-api/add-server";s:9:"edit-form";s:63:"/admin/config/search/search-api/server/{search_api_server}/edit";s:11:"delete-form";s:65:"/admin/config/search/search-api/server/{search_api_server}/delete";s:7:"disable";s:66:"/admin/config/search/search-api/server/{search_api_server}/disable";s:6:"enable";s:65:"/admin/config/search/search-api/server/{search_api_server}/enable";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Search server";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"Search servers";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"search server";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"search servers";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:20:"@count search server";s:6:"plural";s:21:"@count search servers";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:29:"config:search_api_server_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:6:"server";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:5:{i:0;s:2:"id";i:1;s:4:"name";i:2;s:11:"description";i:3;s:7:"backend";i:4;s:14:"backend_config";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'search_api_task.entity_type',
  'value' => 'O:36:"Drupal\Core\Entity\ContentEntityType":41:{s:5:" * id";s:15:"search_api_task";s:8:" * class";s:29:"Drupal\search_api\Entity\Task";s:11:" * provider";s:10:"search_api";s:15:" * static_cache";b:1;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:6:{s:2:"id";s:2:"id";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:" * originalClass";s:29:"Drupal\search_api\Entity\Task";s:11:" * handlers";a:3:{s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:46:"Drupal\Core\Entity\Sql\SqlContentEntityStorage";s:12:"view_builder";s:36:"Drupal\Core\Entity\EntityViewBuilder";}s:19:" * admin_permission";N;s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";s:15:"search_api_task";s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Search task";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Search tasks";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"search task";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"search tasks";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:18:"@count search task";s:6:"plural";s:19:"@count search tasks";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:7:"content";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Content";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:20:"search_api_task_list";}s:14:" * constraints";a:1:{s:26:"EntityUntranslatableFields";N;}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:25:" * revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'search_api_task.field_storage_definitions',
  'value' => 'a:5:{s:2:"id";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"ID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"search_api";s:10:"field_name";s:2:"id";s:11:"entity_type";s:15:"search_api_task";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:" * fieldDefinition";r:2;}s:7:" * type";s:7:"integer";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:4:"type";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:8:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Task type";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:8:"provider";s:10:"search_api";s:10:"field_name";s:4:"type";s:11:"entity_type";s:15:"search_api_task";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:50;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:36;}s:7:" * type";s:6:"string";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:50;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:9:"server_id";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Server ID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"search_api";s:10:"field_name";s:9:"server_id";s:11:"entity_type";s:15:"search_api_task";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:50;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:68;}s:7:" * type";s:6:"string";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:50;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:8:"index_id";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:8:"Index ID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"search_api";s:10:"field_name";s:8:"index_id";s:11:"entity_type";s:15:"search_api_task";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:50;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:99;}s:7:" * type";s:6:"string";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:50;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:4:"data";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Task data";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"search_api";s:10:"field_name";s:4:"data";s:11:"entity_type";s:15:"search_api_task";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:130;}s:7:" * type";s:11:"string_long";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'search_api_task.entity_schema_data',
  'value' => 'a:1:{s:15:"search_api_task";a:1:{s:11:"primary key";a:1:{i:0;s:2:"id";}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'search_api_task.field_schema_data.data',
  'value' => 'a:1:{s:15:"search_api_task";a:1:{s:6:"fields";a:1:{s:4:"data";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'search_api_task.field_schema_data.id',
  'value' => 'a:1:{s:15:"search_api_task";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'search_api_task.field_schema_data.index_id',
  'value' => 'a:1:{s:15:"search_api_task";a:1:{s:6:"fields";a:1:{s:8:"index_id";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:50;s:6:"binary";b:0;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'search_api_task.field_schema_data.server_id',
  'value' => 'a:1:{s:15:"search_api_task";a:1:{s:6:"fields";a:1:{s:9:"server_id";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:50;s:6:"binary";b:0;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'search_api_task.field_schema_data.type',
  'value' => 'a:1:{s:15:"search_api_task";a:1:{s:6:"fields";a:1:{s:4:"type";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:50;s:6:"binary";b:0;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'state',
  'name' => 'elasticsearch_connector_get_default_connector',
  'value' => 's:10:"tacky_pear";',
))
->values(array(
  'collection' => 'state',
  'name' => 'search_api.index.amazing_clock.has_reindexed',
  'value' => 'b:1;',
))
->values(array(
  'collection' => 'state',
  'name' => 'search_api.index.colorful_organization.has_reindexed',
  'value' => 'b:1;',
))
->values(array(
  'collection' => 'state',
  'name' => 'search_api.index.drab_feather.has_reindexed',
  'value' => 'b:1;',
))
->values(array(
  'collection' => 'state',
  'name' => 'search_api.index.dramatic_bicycle.has_reindexed',
  'value' => 'b:1;',
))
->values(array(
  'collection' => 'state',
  'name' => 'search_api.index.parched_arithmetic.has_reindexed',
  'value' => 'b:1;',
))
->values(array(
  'collection' => 'state',
  'name' => 'search_api.index.robust_discussion.has_reindexed',
  'value' => 'b:1;',
))
->values(array(
  'collection' => 'state',
  'name' => 'search_api.index.yummy_lettuce.has_reindexed',
  'value' => 'b:1;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'elasticsearch_connector',
  'value' => 'i:8000;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'search_api',
  'value' => 'i:8110;',
))
->execute();

$connection->schema()->createTable('search_api_task', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '50',
    ),
    'server_id' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '50',
    ),
    'index_id' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '50',
    ),
    'data' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'mysql_character_set' => 'utf8mb4',
));

// Reset the SQL mode.
if ($connection->databaseType() === 'mysql') {
  $connection->query("SET sql_mode = '$sql_mode'");
}
