(function ($, Drupal, drupalSettings, once) {
  'use strict';

  Drupal.behaviors.searchInlineBehavior = {
    attach: function (context, settings) {
      var header_form_class = drupalSettings.elasticsearch_search_api.header_form_class;
      var searchForm = $('.' + header_form_class);
      $(once('elasticsearch_search_api-autocomplete', '.search-autocomplete-inline')).on('click', '.autocomplete-keyword', function () {
        searchForm.find('input[name=keyword]').val($(this).attr('data-keyword'));
        searchForm.submit();
      });

      $(once('elasticsearch_search_api-autocomplete', searchForm)).on('submit', function () {
        $('.search-autocomplete-inline').removeClass('is-visible');
      });

      var delay = (function () {
        var timer = 0;
        return function (callback, ms) {
          clearTimeout(timer);
          timer = setTimeout(callback, ms);
        };
      })();

      let form_input = searchForm.find('input[name=keyword]');
      $(once('elasticsearch_search_api-keyup', form_input)).on('keyup', function () {
        var q = $(this).val().trim();

        if (q.length > 2) {
          delay(function () {

            var prefix = drupalSettings.langcode;
            var url = drupalSettings.elasticsearch_search_api.autocomplete_endpoint;
            if (prefix) {
              url = '/' + prefix + url;
            }

            $.ajax({
              url: url,
              data: {
                q: q,
                t: 1
              },
              success: function (data) {
                $('.search-autocomplete-inline').html(data).addClass('is-visible');
              }
            });
          }, 300);
        }
        else {
          $('.search-autocomplete-inline').html('');
        }
      });

      $(once('elasticsearch_search_api-blur', form_input)).on('blur', function () {
        setTimeout(function () {
          $('.search-autocomplete-inline').removeClass('is-visible');
        }, 200);

      });
    }
  };

})(jQuery, Drupal, drupalSettings, once);
