<?php

namespace Drupal\elasticsearch_search_api\Factory;

use Drupal\elasticsearch_search_api\KeymatchEntry;

/**
 * Class KeymatchEntryFactory.
 */
class KeymatchEntryFactory {

  /**
   * Creates a KeymatchEntry object.
   *
   * @param string $keymatch_entry
   *   Keymatch entry as a string.
   *
   * @return \Drupal\elasticsearch_search_api\KeymatchEntry
   *   Returns a KeymatchEntry object
   */
  public function createEntry(string $keymatch_entry) {
    return new KeymatchEntry($keymatch_entry);
  }

}
