<?php

namespace Drupal\elasticsearch_search_api;

/**
 * A KeymatchEntry Object.
 */
class KeymatchEntry {

  /**
   * The keymatch query.
   *
   * @var string
   */
  private $query;

  /**
   * The keymatch url.
   *
   * @var string
   */
  private $url;

  /**
   * The keymatch title.
   *
   * @var string
   */
  private $title;

  /**
   * The keymatch type.
   *
   * @var string
   */
  private $type;

  /**
   * KeymatchEntry constructor.
   *
   * @param string $keymatch_entry
   *   Keymatch entry as string.
   */
  public function __construct($keymatch_entry) {
    $parts = explode(',', $keymatch_entry);
    $this->query = $parts[0];
    $this->url = $parts[2];
    $this->title = $parts[3];
    $this->type = $parts[1];
  }

  /**
   * Gets the query.
   *
   * @return string
   *   The keymatch query.
   */
  public function getQuery() {
    return $this->query;
  }

  /**
   * Gets the url.
   *
   * @return string
   *   The keymatch url.
   */
  public function getUrl() {
    return $this->url;
  }

  /**
   * Gets the title.
   *
   * @return string
   *   The keymatch title.
   */
  public function getTitle() {
    return $this->title;
  }

  /**
   * Gets the type.
   *
   * @return string
   *   The keymatch type.
   */
  public function getType() {
    return $this->type;
  }

}
