<?php

namespace Drupal\Tests\image_effects\Unit;

use Drupal\image_effects\Component\PositionedRectangle;
use PHPUnit\Framework\TestCase;

/**
 * Tests the Rectangle algebra class.
 *
 * @coversDefaultClass \Drupal\image_effects\Component\PositionedRectangle
 *
 * @group image_effects
 */
class PositionedRectangleTest extends TestCase {

  /**
   * @covers ::resize
   * @covers ::setPoint
   * @covers ::getPoint
   */
  public function testResize() {
    $rect = new PositionedRectangle(200, 100);
    $rect->setPoint('test_a', [20, 10]);
    $this->assertSame(200, $rect->getWidth());
    $this->assertSame(100, $rect->getHeight());
    $this->assertSame([0, 0], $rect->getPoint('c_a'));
    $this->assertSame([199, 0], $rect->getPoint('c_b'));
    $this->assertSame([199, 99], $rect->getPoint('c_c'));
    $this->assertSame([0, 99], $rect->getPoint('c_d'));
    $this->assertSame([0, 0], $rect->getPoint('o_a'));
    $this->assertSame([199, 99], $rect->getPoint('o_c'));
    $this->assertSame([20, 10], $rect->getPoint('test_a'));
    $rect->resize(137, 54);
    $this->assertSame(137, $rect->getWidth());
    $this->assertSame(54, $rect->getHeight());
    $this->assertSame([0, 0], $rect->getPoint('c_a'));
    $this->assertSame([136, 0], $rect->getPoint('c_b'));
    $this->assertSame([136, 53], $rect->getPoint('c_c'));
    $this->assertSame([0, 53], $rect->getPoint('c_d'));
    $this->assertSame([0, 0], $rect->getPoint('o_a'));
    $this->assertSame([136, 53], $rect->getPoint('o_c'));
    $this->assertSame([14, 5], $rect->getPoint('test_a'));
  }

  /**
   * Data provider for testAddGrid.
   */
  public function addGridProvider() {
    return [
      '800x600, grid 5x5, full' => [
        800,
        600,
        0,
        0,
        800,
        600,
        5,
        5,
        [
          'c_a' => [0, 0],
          'c_b' => [799, 0],
          'c_c' => [799, 599],
          'c_d' => [0, 599],
          'o_a' => [0, 0],
          'o_c' => [799, 599],
          'test_a_0_0' => [0, 0],
          'test_a_1_0' => [0, 120],
          'test_a_2_0' => [0, 240],
          'test_a_3_0' => [0, 360],
          'test_a_4_0' => [0, 480],
          'test_a_5_0' => [0, 600],
          'test_a_0_1' => [160, 0],
          'test_a_1_1' => [160, 120],
          'test_a_2_1' => [160, 240],
          'test_a_3_1' => [160, 360],
          'test_a_4_1' => [160, 480],
          'test_a_5_1' => [160, 600],
          'test_a_0_2' => [320, 0],
          'test_a_1_2' => [320, 120],
          'test_a_2_2' => [320, 240],
          'test_a_3_2' => [320, 360],
          'test_a_4_2' => [320, 480],
          'test_a_5_2' => [320, 600],
          'test_a_0_3' => [480, 0],
          'test_a_1_3' => [480, 120],
          'test_a_2_3' => [480, 240],
          'test_a_3_3' => [480, 360],
          'test_a_4_3' => [480, 480],
          'test_a_5_3' => [480, 600],
          'test_a_0_4' => [640, 0],
          'test_a_1_4' => [640, 120],
          'test_a_2_4' => [640, 240],
          'test_a_3_4' => [640, 360],
          'test_a_4_4' => [640, 480],
          'test_a_5_4' => [640, 600],
          'test_a_0_5' => [800, 0],
          'test_a_1_5' => [800, 120],
          'test_a_2_5' => [800, 240],
          'test_a_3_5' => [800, 360],
          'test_a_4_5' => [800, 480],
          'test_a_5_5' => [800, 600],
        ],
        [
          '1, 1, 3, 3' => [480, 360],
          '0, 0, 1, 1' => [160, 120],
          '1, 1, 1, 1' => [160, 120],
          '2, 2, 1, 1' => [160, 120],
        ],
      ],
      '800x600, grid 17x13, full' => [
        800,
        600,
        0,
        0,
        800,
        600,
        17,
        13,
        [
          'c_a' => [0, 0],
          'c_b' => [799, 0],
          'c_c' => [799, 599],
          'c_d' => [0, 599],
          'o_a' => [0, 0],
          'o_c' => [799, 599],
          'test_a_0_0' => [0, 0],
          'test_a_1_0' => [0, 35],
          'test_a_2_0' => [0, 70],
          'test_a_3_0' => [0, 105],
          'test_a_4_0' => [0, 140],
          'test_a_5_0' => [0, 175],
          'test_a_6_0' => [0, 211],
          'test_a_7_0' => [0, 247],
          'test_a_8_0' => [0, 283],
          'test_a_9_0' => [0, 319],
          'test_a_10_0' => [0, 355],
          'test_a_11_0' => [0, 390],
          'test_a_12_0' => [0, 425],
          'test_a_13_0' => [0, 460],
          'test_a_14_0' => [0, 495],
          'test_a_15_0' => [0, 530],
          'test_a_16_0' => [0, 565],
          'test_a_17_0' => [0, 600],
          'test_a_0_1' => [61, 0],
          'test_a_1_1' => [61, 35],
          'test_a_2_1' => [61, 70],
          'test_a_3_1' => [61, 105],
          'test_a_4_1' => [61, 140],
          'test_a_5_1' => [61, 175],
          'test_a_6_1' => [61, 211],
          'test_a_7_1' => [61, 247],
          'test_a_8_1' => [61, 283],
          'test_a_9_1' => [61, 319],
          'test_a_10_1' => [61, 355],
          'test_a_11_1' => [61, 390],
          'test_a_12_1' => [61, 425],
          'test_a_13_1' => [61, 460],
          'test_a_14_1' => [61, 495],
          'test_a_15_1' => [61, 530],
          'test_a_16_1' => [61, 565],
          'test_a_17_1' => [61, 600],
          'test_a_0_2' => [122, 0],
          'test_a_1_2' => [122, 35],
          'test_a_2_2' => [122, 70],
          'test_a_3_2' => [122, 105],
          'test_a_4_2' => [122, 140],
          'test_a_5_2' => [122, 175],
          'test_a_6_2' => [122, 211],
          'test_a_7_2' => [122, 247],
          'test_a_8_2' => [122, 283],
          'test_a_9_2' => [122, 319],
          'test_a_10_2' => [122, 355],
          'test_a_11_2' => [122, 390],
          'test_a_12_2' => [122, 425],
          'test_a_13_2' => [122, 460],
          'test_a_14_2' => [122, 495],
          'test_a_15_2' => [122, 530],
          'test_a_16_2' => [122, 565],
          'test_a_17_2' => [122, 600],
          'test_a_0_3' => [184, 0],
          'test_a_1_3' => [184, 35],
          'test_a_2_3' => [184, 70],
          'test_a_3_3' => [184, 105],
          'test_a_4_3' => [184, 140],
          'test_a_5_3' => [184, 175],
          'test_a_6_3' => [184, 211],
          'test_a_7_3' => [184, 247],
          'test_a_8_3' => [184, 283],
          'test_a_9_3' => [184, 319],
          'test_a_10_3' => [184, 355],
          'test_a_11_3' => [184, 390],
          'test_a_12_3' => [184, 425],
          'test_a_13_3' => [184, 460],
          'test_a_14_3' => [184, 495],
          'test_a_15_3' => [184, 530],
          'test_a_16_3' => [184, 565],
          'test_a_17_3' => [184, 600],
          'test_a_0_4' => [246, 0],
          'test_a_1_4' => [246, 35],
          'test_a_2_4' => [246, 70],
          'test_a_3_4' => [246, 105],
          'test_a_4_4' => [246, 140],
          'test_a_5_4' => [246, 175],
          'test_a_6_4' => [246, 211],
          'test_a_7_4' => [246, 247],
          'test_a_8_4' => [246, 283],
          'test_a_9_4' => [246, 319],
          'test_a_10_4' => [246, 355],
          'test_a_11_4' => [246, 390],
          'test_a_12_4' => [246, 425],
          'test_a_13_4' => [246, 460],
          'test_a_14_4' => [246, 495],
          'test_a_15_4' => [246, 530],
          'test_a_16_4' => [246, 565],
          'test_a_17_4' => [246, 600],
          'test_a_0_5' => [308, 0],
          'test_a_1_5' => [308, 35],
          'test_a_2_5' => [308, 70],
          'test_a_3_5' => [308, 105],
          'test_a_4_5' => [308, 140],
          'test_a_5_5' => [308, 175],
          'test_a_6_5' => [308, 211],
          'test_a_7_5' => [308, 247],
          'test_a_8_5' => [308, 283],
          'test_a_9_5' => [308, 319],
          'test_a_10_5' => [308, 355],
          'test_a_11_5' => [308, 390],
          'test_a_12_5' => [308, 425],
          'test_a_13_5' => [308, 460],
          'test_a_14_5' => [308, 495],
          'test_a_15_5' => [308, 530],
          'test_a_16_5' => [308, 565],
          'test_a_17_5' => [308, 600],
          'test_a_0_6' => [370, 0],
          'test_a_1_6' => [370, 35],
          'test_a_2_6' => [370, 70],
          'test_a_3_6' => [370, 105],
          'test_a_4_6' => [370, 140],
          'test_a_5_6' => [370, 175],
          'test_a_6_6' => [370, 211],
          'test_a_7_6' => [370, 247],
          'test_a_8_6' => [370, 283],
          'test_a_9_6' => [370, 319],
          'test_a_10_6' => [370, 355],
          'test_a_11_6' => [370, 390],
          'test_a_12_6' => [370, 425],
          'test_a_13_6' => [370, 460],
          'test_a_14_6' => [370, 495],
          'test_a_15_6' => [370, 530],
          'test_a_16_6' => [370, 565],
          'test_a_17_6' => [370, 600],
          'test_a_0_7' => [432, 0],
          'test_a_1_7' => [432, 35],
          'test_a_2_7' => [432, 70],
          'test_a_3_7' => [432, 105],
          'test_a_4_7' => [432, 140],
          'test_a_5_7' => [432, 175],
          'test_a_6_7' => [432, 211],
          'test_a_7_7' => [432, 247],
          'test_a_8_7' => [432, 283],
          'test_a_9_7' => [432, 319],
          'test_a_10_7' => [432, 355],
          'test_a_11_7' => [432, 390],
          'test_a_12_7' => [432, 425],
          'test_a_13_7' => [432, 460],
          'test_a_14_7' => [432, 495],
          'test_a_15_7' => [432, 530],
          'test_a_16_7' => [432, 565],
          'test_a_17_7' => [432, 600],
          'test_a_0_8' => [494, 0],
          'test_a_1_8' => [494, 35],
          'test_a_2_8' => [494, 70],
          'test_a_3_8' => [494, 105],
          'test_a_4_8' => [494, 140],
          'test_a_5_8' => [494, 175],
          'test_a_6_8' => [494, 211],
          'test_a_7_8' => [494, 247],
          'test_a_8_8' => [494, 283],
          'test_a_9_8' => [494, 319],
          'test_a_10_8' => [494, 355],
          'test_a_11_8'  => [494, 390],
          'test_a_12_8' => [494, 425],
          'test_a_13_8' => [494, 460],
          'test_a_14_8' => [494, 495],
          'test_a_15_8' => [494, 530],
          'test_a_16_8' => [494, 565],
          'test_a_17_8' => [494, 600],
          'test_a_0_9' => [556, 0],
          'test_a_1_9' => [556, 35],
          'test_a_2_9' => [556, 70],
          'test_a_3_9' => [556, 105],
          'test_a_4_9' => [556, 140],
          'test_a_5_9' => [556, 175],
          'test_a_6_9' => [556, 211],
          'test_a_7_9' => [556, 247],
          'test_a_8_9' => [556, 283],
          'test_a_9_9' => [556, 319],
          'test_a_10_9' => [556, 355],
          'test_a_11_9' => [556, 390],
          'test_a_12_9' => [556, 425],
          'test_a_13_9' => [556, 460],
          'test_a_14_9' => [556, 495],
          'test_a_15_9' => [556, 530],
          'test_a_16_9' => [556, 565],
          'test_a_17_9' => [556, 600],
          'test_a_0_10' => [617, 0],
          'test_a_1_10' => [617, 35],
          'test_a_2_10' => [617, 70],
          'test_a_3_10' => [617, 105],
          'test_a_4_10' => [617, 140],
          'test_a_5_10' => [617, 175],
          'test_a_6_10' => [617, 211],
          'test_a_7_10' => [617, 247],
          'test_a_8_10' => [617, 283],
          'test_a_9_10' => [617, 319],
          'test_a_10_10' => [617, 355],
          'test_a_11_10' => [617, 390],
          'test_a_12_10' => [617, 425],
          'test_a_13_10' => [617, 460],
          'test_a_14_10' => [617, 495],
          'test_a_15_10' => [617, 530],
          'test_a_16_10' => [617, 565],
          'test_a_17_10' => [617, 600],
          'test_a_0_11' => [678, 0],
          'test_a_1_11' => [678, 35],
          'test_a_2_11' => [678, 70],
          'test_a_3_11' => [678, 105],
          'test_a_4_11' => [678, 140],
          'test_a_5_11' => [678, 175],
          'test_a_6_11' => [678, 211],
          'test_a_7_11' => [678, 247],
          'test_a_8_11' => [678, 283],
          'test_a_9_11' => [678, 319],
          'test_a_10_11' => [678, 355],
          'test_a_11_11' => [678, 390],
          'test_a_12_11' => [678, 425],
          'test_a_13_11' => [678, 460],
          'test_a_14_11' => [678, 495],
          'test_a_15_11' => [678, 530],
          'test_a_16_11' => [678, 565],
          'test_a_17_11' => [678, 600],
          'test_a_0_12' => [739, 0],
          'test_a_1_12' => [739, 35],
          'test_a_2_12' => [739, 70],
          'test_a_3_12' => [739, 105],
          'test_a_4_12' => [739, 140],
          'test_a_5_12' => [739, 175],
          'test_a_6_12' => [739, 211],
          'test_a_7_12' => [739, 247],
          'test_a_8_12' => [739, 283],
          'test_a_9_12' => [739, 319],
          'test_a_10_12' => [739, 355],
          'test_a_11_12' => [739, 390],
          'test_a_12_12' => [739, 425],
          'test_a_13_12' => [739, 460],
          'test_a_14_12' => [739, 495],
          'test_a_15_12' => [739, 530],
          'test_a_16_12' => [739, 565],
          'test_a_17_12' => [739, 600],
          'test_a_0_13' => [800, 0],
          'test_a_1_13' => [800, 35],
          'test_a_2_13' => [800, 70],
          'test_a_3_13' => [800, 105],
          'test_a_4_13' => [800, 140],
          'test_a_5_13' => [800, 175],
          'test_a_6_13' => [800, 211],
          'test_a_7_13' => [800, 247],
          'test_a_8_13' => [800, 283],
          'test_a_9_13' => [800, 319],
          'test_a_10_13' => [800, 355],
          'test_a_11_13' => [800, 390],
          'test_a_12_13' => [800, 425],
          'test_a_13_13' => [800, 460],
          'test_a_14_13' => [800, 495],
          'test_a_15_13' => [800, 530],
          'test_a_16_13' => [800, 565],
          'test_a_17_13' => [800, 600],
        ],
        [
          '1, 1, 5, 3' => [185, 176],
          '0, 0, 1, 1' => [61, 35],
          '2, 2, 1, 1' => [62, 35],
        ],
      ],
    ];
  }

  /**
   * @covers ::addGrid
   * @covers ::getSubGridDimensions
   * @covers ::getPoints
   * @dataProvider addGridProvider
   */
  public function testAddGrid($rect_width, $rect_height, $x, $y, $width, $height, $rows, $columns, $expected_points, $expected_subgrid_dimensions) {
    $rect = new PositionedRectangle($rect_width, $rect_height);
    $rect->addGrid('test_a', $x, $y, $width, $height, $rows, $columns);
    $this->assertEquals($expected_points, $rect->getPoints());
    foreach ($expected_subgrid_dimensions as $params => $dimensions) {
      $args = explode(', ', $params);
      $this->assertSame($dimensions, $rect->getSubGridDimensions('test_a', $args[0], $args[1], $args[2], $args[3]));
    }
  }

}
