#  STYLE GUIDE

Provides a visual testing page for Drupal themes. Quickly compare the display
of common elements across your themes, and verify that your new theme addresses
all common style elements.

The Style Guide module creates a preview page for displaying common theme
elements in all active themes for your Drupal site. The module comes with
previews for common HTML elements, such as tables, forms, links and lists.

## PURPOSE

The purpose of a visual style guide as both a general theming and development
tool is to ensure that common site elements are styled in a consistent and
intentional way. For further reference see

- Wikipedia: Style guide
- Front-end Style Guides from 24 Ways.org
- Trust in Styleguide

## INSTALLATION

See [Installing contributed modules](https://www.drupal.org/docs/extending-drupal/installing-modules)

## Using Style Guide

- You must be logged in as user with the "View theme style guides" permission.
- Navigate to <http://example.com/admin/appearance/styleguide> and you will see
  a style guide for the current default theme.
- Using the tabs at the top of the page, you can switch to viewing the style
  guide in other enabled theme.
- Using Style Guide Palette
- Enable the styleguide_palette module that's bundled with the styleguide
  module.
- You must be logged in as user with the "Configure style guide palettes"
  permission.
- Navigate to
  <http://example.com/admin/config/user-interface/styleguide-palette/edit> and
  you will see settings for adding a new color swatch to the palette.
- Once you've added all of the swatches you desire for the palette, visit the
  usual style guide configuration for your theme at
  <http://example.com/admin/appearance/styleguide>.

## MAINTAINERS
<!--- cspell:disable -->
- Ken Rickard (agentrickard) - <https://www.drupal.org/u/agentrickard>
- Megh Plunkett (dead_arm) - <https://www.drupal.org/u/dead_arm>
- Bevan Rudge (Bevan) - <https://www.drupal.org/u/bevan>
- Dave Reid - <https://www.drupal.org/u/dave-reid>
- Jeff Geerling (geerlingguy) - <https://www.drupal.org/u/geerlingguy>
- irakli - <https://www.drupal.org/u/irakli>
- Matt Farina (mfer) - <https://www.drupal.org/u/mfer>
- Richard Burford (psynaptic) - <https://www.drupal.org/u/psynaptic>
- Greg Boggs - <https://www.drupal.org/u/greg-boggs>
- Oleksiy Stepaniuk (Oleksiy) - <https://www.drupal.org/u/oleksiy>
- markabur - <https://www.drupal.org/u/markabur>
- dcam = <https://www.drupal.org/u/dcam>
<!--- cspell:enable -->
