<?php

namespace Drupal\azure_login\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Language\LanguageManagerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Defines a form that configures forms module settings.
 */
class SiteConfigurationForm extends ConfigFormBase {

  /**
   * The language manager.
   *
   * @var \Drupal\Core\Language\LanguageManagerInterface
   */
  protected $languageManager;

  /**
   * The file system service.
   *
   * @var \Drupal\Core\File\FileSystemInterface
   */
  protected $fileSystem;

  /**
   * Constructs a new SiteConfiguration Form.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The factory for configuration objects.
   * @param \Drupal\Core\Language\LanguageManagerInterface $language_manager
   *   The language manager.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager service.
   */
  public function __construct(ConfigFactoryInterface $config_factory, LanguageManagerInterface $language_manager) {
    parent::__construct($config_factory);

    $this->languageManager = $language_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory'),
      $container->get('language_manager')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'azure_login_site_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'azure_login.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('azure_login.settings');

    $form['cilentId'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Application (client) ID'),
      '#description' => $this->t('Enter a Application (client) ID. For ex. 6cacbe9f-a562-4841-9c0e-42617785fae5'),
      '#default_value' => $config->get('cilentId'),
    ];
    $form['tenantID'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Directory (tenant) ID'),
      '#description' => $this->t('Enter a Directory (tenant) ID. For ex. a01c4e5e-95f9-4ab2-9f18-2469e29f5140'),
      '#default_value' => $config->get('tenantID'),
    ];
    
    $form['clientSecret'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Secret Value'),
      '#description' => "Enter a Secret Value. For ex. h1P8Q~1T123cl_byaqNbLozVfrtdrvdfs6M8N7.Ybb~b",
      '#default_value' => $config->get('clientSecret'),
    ];
    
    $form['redirectUrl'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Redirect URL'),
      '#default_value' => $config->get('redirectUrl'),
    ];
    
    $form['default_password'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Default Password'),
      '#default_value' => $config->get('default_password'),
    ];
    
    $form['group_id'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Group ID'),
      '#default_value' => $config->get('group_id'),
      '#description' => "Enter a Group ID. For ex. kf3cc60f-79ad-4766-b530-o1da86e373c0"
    ];
    
    $form_state->setCached(FALSE);

    return parent::buildForm($form, $form_state); 
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = \Drupal::getContainer()->get('config.factory')->getEditable('azure_login.settings');
    //$this->config('azure_login_site_settings.settings')
      $config->set('cilentId', $form_state->getValue('cilentId'));
      if (!empty($form_state->getValue('clientSecret'))) {
        $config->set('clientSecret', $form_state->getValue('clientSecret'));
      }
      $config->set('redirectUrl', $form_state->getValue('redirectUrl'));
      $config->set('tenantID', $form_state->getValue('tenantID'));
      $config->set('default_password', $form_state->getValue('default_password'));
      $config->set('group_id', $form_state->getValue('group_id'));
      $config->save();
    parent::submitForm($form, $form_state);
  }

}
