<?php

namespace Drupal\azure_login\Plugin\Block;

/**
 * @file
 * Contains \Drupal\yrdsb_workflow\Plugin\Block\GoogleCalendarBlock4.
 */

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\user\Entity\User;
use Drupal\Component\Serialization\Json;
use Drupal\yrdsb_workflow\calendarapi;

/**
 * Provide Azure Login block.
 *
 * @Block(
 *   id = "azure_login_block",
 *   admin_label = @Translation("Azure Login Block"),
 * )
 */
class AzureLoginBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'azure_login_block';
  }

  /**
   * {@inheritdoc}
   */
  public function build() {
    $config = \Drupal::config('azure_login.settings');
    $clientid = $config->get('cilentId');
    $clientSecret = $config->get('clientSecret');
    $redirectUrl = $config->get('redirectUrl');
    $tenantID = $config->get('tenantID');
    $azureApiUrl = "https://login.microsoftonline.com/".$config->get('tenantID')."/oauth2";
    
    $url = $azureApiUrl . "/authorize?client_id=".$clientid."&response_type=code&redirect_uri=".$redirectUrl."&response_mode=query&scope=user.read profile openid offline_access&state=12345";
    
    return [
        '#markup' => '<div><a href="'.$url.'" target="_blank">Azure SSO Login</a></div>',
        '#cache' => ['max-age' => 0],
    ];
  }

}
