<?php

namespace Drupal\goutte;

/**
 * Class BatchProcessor imports BatchProcessor.
 */
class BatchProcessor {

  /**
   * Short description for $importer.
   *
   * @var Drupal\goutte\GoutteImporter
   */
  protected $importer;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->importer = new GoutteImporter();
  }

  /**
   * Short description for batch_import_content.
   */
  public function batchImportContent($item, &$context) {

    $context['sandbox']['current_item'] = $item;
    $message = 'Loading ' . $item['url'];

    /* Process your batch file */
    $this->importer->importContent($item);

    $context['message'] = $message;
    $context['results'][] = $item;

  }

  /**
   * Callback when the batch processing is complete.
   */
  public function batchImportContentCallback($success, $results, $operations) {
    // The 'success' parameter means no fatal PHP errors were detected. All
    // other error management should be handled using 'results'.
    if ($success) {
      $message = \Drupal::translation()->formatPlural(
        count($results),
        'One content item processed.', '@count items processed.'
      );
    }
    else {
      $message = t('Finished with an error.');
    }
    drupal_set_message($message);
  }

}
