<?php

namespace Drupal\goutte;

/**
 * Class ContentMassager imports ContentMassager.
 */
class ContentMassager {

  /**
   * Helper to massage a variable.
   */
  public function htmlEntityEncode($value) {
    $value = htmlentities($value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function htmlEntityDecode($value) {
    $value = html_entity_decode($value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function removeLineBreaks($value) {
    $value = preg_replace('/\s\s+/', '', $value);
    $value = str_replace("\n", '', $value);
    $value = str_replace("\t", '', $value);
    $value = trim($value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function replaceFilePath($value, $original, $replacement) {
    $value = str_replace($original, $replacement, $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function removeH1($value) {
    $value = preg_replace('#<h1>(.*?)</h1>#', '', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function replaceTagtoTag($value, $tagFrom, $tagTo) {
    $value = preg_replace('#<' . $tagFrom . '(.*?)</' . $tagFrom . '>#', '<' . $tagTo . '$1</' . $tagTo . '>', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function removeTitle($value) {
    $value = preg_replace('#<div class="YRDSBPageTitle">(.*?)</div>#', '', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function removeDivIded($value, $id) {
    $value = preg_replace('#<div id="' . $id . '">(.*?)</div>#', '', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function removeScripts($value) {
    $value = preg_replace('#<script(.*?)</script>#', '', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function removeString($value, $remove) {
    $value = str_replace($remove, '', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function replaceBtags($value) {
    $value = str_replace("<b>", "<strong>", $value);
    $value = str_replace("</b>", "</strong>", $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function removeBackToNews($value) {
    $value = preg_replace('#<div class="newsBackLink content ddContent">(.*?)</div>#', '', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function removeNewsDate($value) {
    $value = preg_replace('#<span class="txtDate">(.*?)</span>#', '', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function removeSpanDisplayNone($value) {
    $value = preg_replace('#<span style="display:none">(.*?)</span>#', '', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function removeShareButtons($value) {
    $value = preg_replace('#<div class="post-share-buttons">(.*?)</div>#', '', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function removeTargetBlank($value) {
    $value = str_replace('target="_blank"', '', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function replaceNbsp($value) {
    $value = str_replace("\xc2\xa0", ' ', $value);
    $value = str_replace("&nbsp;", ' ', $value);
    $value = hex2bin(str_replace('c2a0', '20', bin2hex($value)));
    $value = preg_replace('~\x{00a0}~siu', ' ', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function removeEmptyParagraphs($value) {
    $value = str_replace('<p style="margin: 0in 0in 10pt;">', '<p>', $value);
    $value = str_replace('<p style="margin: 0in 0in 0pt;">', '<p>', $value);
    $value = str_replace('<p style="margin: 0cm 0cm 0pt;">', '<p>', $value);
    $value = str_replace('<p style="margin-bottom: 0pt;">', '<p>', $value);
    $value = str_replace('<p class="Default">', '<p>', $value);
    $value = str_replace('<p style="margin: 0in 0in 0pt; text-align: justify;">', '<p>', $value);
    $value = str_replace('<p><strong> </strong></p>', '', $value);
    $value = str_replace('<p></p>', '', $value);
    $value = str_replace('<p>&nbsp;</p>', '', $value);
    $value = str_replace('<p> </p>', '', $value);
    $value = str_replace('<p>  </p>', '', $value);
    $value = str_replace('<div></div>', '', $value);
    $value = str_replace('<div> </div>', '', $value);
    $value = str_replace('<div>  </div>', '', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function removeAbsoluteUrls($value) {
    $value = str_replace('http://yrdsb.ca', '', $value);
    $value = str_replace('https://yrdsb.ca', '', $value);
    return $value;
  }

  /**
   * Helper to massage a variable.
   */
  public function cleanHtmlTagsAttributes($value, $attributes) {
    foreach ($attributes as $key => $attribute) {
      $pattern = '# ' . $attribute . '="[^"]*"#';
      $value = preg_replace($pattern, '', $value);
    }
    return $value;
  }

}
