<?php

namespace Drupal\goutte;

use Guzzle\Common\Event;
use Guzzle\Http\Message\Header;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Class ForceCharsetPlugin implements EventsubscriberInterface.
 */
class ForceCharsetPlugin implements EventSubscriberInterface {

  /**
   * Short description for $forcedCharset.
   *
   * @var string
   */
  private $forcedCharset = 'utf8';

  /**
   * Helper to set ForcedCharset.
   */
  public function setForcedCharset($charset) {
    $this->forcedCharset = $charset;
    return $this;
  }

  /**
   * Helper to get ForcedCharset.
   */
  public function getForcedCharset() {
    return $this->forcedCharset;
  }

  /**
   * Helper to get SubscribedEvents.
   */
  public static function getSubscribedEvents() {
    return [
      'request.complete' => 'onRequestComplete',
    ];
  }

  /**
   * Helper on request complete.
   */
  public function onRequestComplete(Event $event) {
    $response = $event['response'];
    $header = $response->getHeader('content-type');
    $modified = new Header(
      $header->getName(),
      array_map([$this, 'modifyParams'], $header->parseParams()),
      $header->getGlue()
    );
    $response->setHeader('content-type', $modified);
  }

  /**
   * Helper to modify params.
   */
  private function modifyParams(array $headerParams) {
    $headerParams['charset'] = $this->getForcedCharset();
    return urldecode(http_build_query($headerParams, NULL, ';'));
  }

}
