<?php

namespace Drupal\goutte;

use Symfony\Component\DomCrawler\Crawler;
use Goutte\Client as GoutteClient;

/**
 * GoutteConnector class imports GoutteConnector.
 */
class GoutteConnector {

  /**
   * Short description for Client.
   *
   * @var Goutte\Client
   */
  protected $client;

  /**
   * Short description for Crawler.
   *
   * @var Symfony\Component\DomCrawler\Crawler
   */
  protected $connection;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->client = new GoutteClient();
  }

  /**
   * Connect to a given Url.
   */
  public function connect($url) {
    if ($this->connection = $this->client->request('GET', $url)) {
      return TRUE;
    }
    else {
      return FALSE;
    }
  }

  /**
   * Determine if the crawler has any nodes.
   */
  public function hasNodes() {
    if ($this->connection->count() > 0) {
      return TRUE;
    }
    else {
      return FALSE;
    }
  }

  /**
   * Parse the node by XPath expecting a single result for the path.
   */
  public function parseXpath($filter) {
    $html = '';
    if ($value = $this->connection->filterXPath($filter)->count() > 0) {
      \Drupal::logger('Goutte XPath Content Loop')->notice('in');
      $html = $this->connection->filterXPath($filter)->html();
    }

    // $html = '';
    // foreach ($this->connection as $domElement) {
    // \Drupal::logger('Goutte XPath Content Loop')->notice('in');
    // $html .= $domElement->ownerDocument->saveHTML();
    // }
    \Drupal::logger('Goutte XPath Content After Loop')->notice(var_export($html, TRUE));
    return $html;
  }

  /**
   * Parse the node by XPath expecting a multiple result for the path.
   */
  public function parseXpathContent($filter) {
    $html = $this->connection->filter($filter)->each(function (Crawler $node, $i) {
      $domElement = $node->getNode(0);
      $content = $domElement->ownerDocument->saveHTML($domElement);
      \Drupal::logger('Goutte XPath Content Loop')->notice(var_export($content, TRUE));
      return $content;
    });
    $html = implode("<br>", $html);
    return $html;
  }

  /**
   * Parse the node by XPath and src expecting multiple results for the path.
   */
  public function parseXpathSrc($filter) {
    $html = [];
    if ($value = $this->connection->filterXPath($filter)->count() > 0) {
      $html = $this->connection->filterXPath($filter)->extract(['src']);
    }
    return $html;
  }

  /**
   * Parse the node by Xpath and return attribute.
   */
  public function parseXpathHref($filter) {
    $html = [];
    if ($value = $this->connection->filterXPath($filter)->count() > 0) {
      $html = $this->connection->filterXPath($filter)->extract(['href']);
    }
    return $html;
  }

  /**
   * Unset features.
   */
  public function tearDown() {
    unset($this->client);
    unset($this->crawler);
  }

}
