<?php

namespace Drupal\goutte;

/**
 * Class NodeNormalizer imports NodeNormalizer.
 */
class NodeNormalizer {

  /**
   * Helper to normalize Title.
   */
  public function normalizeTitle($value) {
    $value = strip_tags($value);
    $value = html_entity_decode($value);
    $value = trim($value);
    $value = substr($value, 0, 250);
    return $value;
  }

  /**
   * Helper to normalize Term.
   */
  public function normalizeTerm($value) {
    $value = strip_tags($value);
    $value = html_entity_decode($value);
    $value = ucwords($value);
    $value = trim($value);
    return $value;
  }

  /**
   * Helper to normalize Summary.
   */
  public function normalizeSummary($value) {
    $value = strip_tags($value);
    $value = html_entity_decode($value);
    $value = str_replace('’', '\'', $value);
    $value = trim($value);
    $value = substr($value, 0, 137);
    $value = $value . "...";
    return $value;
  }

  /**
   * Helper to normalize Comment Subject.
   */
  public function normalizeCommentSubject($value) {
    $value = strip_tags($value);
    $value = html_entity_decode($value);
    $value = trim($value);
    $value = substr($value, 0, 60);
    $value = $value . "...";
    return $value;
  }

  /**
   * Helper to normalize Comment Body.
   */
  public function normalizeCommentBody($value) {
    $value = strip_tags($value);
    $value = html_entity_decode($value);
    $value = preg_replace('/[\x00-\x1F\x80-\xFF]/', ' ', $value);
    $value = trim($value);
    return $value;
  }

  /**
   * Helper to normalize Textarea.
   */
  public function normalizeTextarea($value) {
    $allowable_tags = '<a><em><strong><cite><blockquote><code><ul><ol><li><dl><dt><dd><h2><h3><h4><h5><h6><s><sup><sub><img><table><caption><tbody><thead><tfoot><th><td><tr><hr><p><br><pre><u><div><iframe><style>';
    $value = html_entity_decode($value);
    $value = strip_tags($value, $allowable_tags);
    return $value;
  }

  /**
   * Helper to normalize Date.
   */
  public function normalizeDate($value) {
    return strtotime(trim($value));
  }

  /**
   * Helper to normalize Date Field.
   */
  public function normalizeDateField($value) {
    // '2000-01-02T12:13:13'.
    $value = strtotime(trim($value));
    return date('Y-m-d\TH:i:s', $value);
  }

  /**
   * Helper to normalize Legacy.
   */
  public function normalizeLegacy($value) {
    $value = strip_tags($value);
    $value = trim($value);
    $value = strtolower($value);
    return $value;
  }

}
