<?php

namespace Drupal\Tests\goutte\unit;

use Drupal\Tests\UnitTestCase;
use Drupal\goutte\ContentMassager;

/**
 * Simple test to ensure that asserts pass.
 *
 * @group goutte
 */
class ContentMassagerTest extends UnitTestCase {

  /**
   * Short description for $massager.
   *
   * @var Drupal\goutte\ContentMassager
   */
  protected $massager;

  /**
   * Before a test method is run, setUp() is invoked.
   *
   * Create new unit object.
   */
  public function setUp() {
    $this->massager = new ContentMassager();
  }

  /**
   * @covers Drupal\goutte\ContentMassager::replaceImagePath
   */
  public function testReplaceImagePath() {
    $input = '<div class="as"><h1>Welcome to the page</h1><p><img src="http://www.opin.ca/logo.png" alt="Logo"></p></div>';
    $expected = '<div class="as"><h1>Welcome to the page</h1><p><img src="http://www.opin.com/logo.svg" alt="Logo"></p></div>';
    $original = 'http://www.opin.ca/logo.png';
    $replacement = 'http://www.opin.com/logo.svg';
    $output = '';

    $output = $this->massager->replaceImagePath($input, $original, $replacement);
    $this->assertEquals($expected, $output);
  }

  /**
   * @covers Drupal\goutte\ContentMassager::removeH1
   */
  public function testRemoveH1() {
    $input = '<div class="as"><p>By Louise Kinross</p><h1>Welcome to the page</h1><p>Bacon ipsum dolor amet brisket meatball pork, salami andouille landjaeger turkey.</p></div>';
    $expected = '<div class="as"><p>By Louise Kinross</p><p>Bacon ipsum dolor amet brisket meatball pork, salami andouille landjaeger turkey.</p></div>';
    $output = '';

    $output = $this->massager->removeH1($input);
    $this->assertEquals($expected, $output);
  }

  /**
   * @covers Drupal\goutte\ContentMassager::removeString
   */
  public function testRemoveString() {
    $input = '<div class="as"><p>By Louise Kinross</p><h1>Welcome to the page</h1><p>Bacon ipsum dolor amet brisket meatball pork, salami andouille landjaeger turkey.</p></div>';
    $expected = '<div class="as"><h1>Welcome to the page</h1><p>Bacon ipsum dolor amet brisket meatball pork, salami andouille landjaeger turkey.</p></div>';
    $remove = '<p>By Louise Kinross</p>';
    $output = '';

    $output = $this->massager->removeString($input, $remove);
    $this->assertEquals($expected, $output);
  }

  /**
   * @covers Drupal\goutte\ContentMassager::replaceBtags
   */
  public function testReplaceBtags() {
    $input = '<p><b>Welcome to the website</b></p>';
    $expected = '<p><strong>Welcome to the website</strong></p>';
    $output = '';

    $output = $this->massager->replaceBtags($input);
    $this->assertEquals($expected, $output);
  }

  /**
   * @covers Drupal\goutte\ContentMassager::removeBackToNews
   */
  public function testRemoveBackToNews() {
    $input = '<div class="newsBackLink content ddContent">November 28, 2019</div><p><strong>Welcome to the website</strong></p>';
    $expected = '<p><strong>Welcome to the website</strong></p>';
    $output = '';

    $output = $this->massager->removeBackToNews($input);
    $this->assertEquals($expected, $output);
  }

  /**
   * @covers Drupal\goutte\ContentMassager::removeBackToNews
   */
  public function testRemoveBackToNewsB() {
    $input = '<div class="newsBackLink content ddContent"><a class="newsBackLink" href="javascript:history.back()">Back to News</a></div>';
    $expected = '';
    $output = '';

    $output = $this->massager->removeBackToNews($input);
    $this->assertEquals($expected, $output);
  }

  /**
   * @covers Drupal\goutte\ContentMassager::removeNewsDate
   */
  public function testNewsDate() {
    $input = '<p class="date"><strong>August 12, 2013</strong></p><p><strong>Welcome to the website</strong></p>';
    $expected = '<p><strong>Welcome to the website</strong></p>';
    $output = '';

    $output = $this->massager->removeNewsDate($input);
    $this->assertEquals($expected, $output);
  }

  /**
   * @covers Drupal\goutte\ContentMassager::removeNewsDate
   */
  public function testNewsDateB() {
    $input = '<p class="date"><strong>August 12, 2013</strong></p>';
    $expected = '';
    $output = '';

    $output = $this->massager->removeNewsDate($input);
    $this->assertEquals($expected, $output);
  }

  /**
   * @covers Drupal\goutte\ContentMassager::removeSpanDisplayNone
   */
  public function testRemoveSpanDisplayNone() {
    $input = '<span style="display:none"><li class="fs-title1 active">Holland Bloorview Autism Study on CTV Nationa...</li></span>';
    $expected = '';
    $output = '';

    $output = $this->massager->removeSpanDisplayNone($input);
    $this->assertEquals($expected, $output);
  }

  /**
   * Whether it succeeded or failed, tearDown() will be invoked.
   *
   * Unset the $unit object.
   */
  public function tearDown() {
    unset($this->massager);
  }

}
