<?php

namespace Drupal\Tests\goutte\unit;

use Drupal\Tests\UnitTestCase;
use Drupal\goutte\GoutteConnector;

/**
 * Simple test to ensure that asserts pass.
 *
 * @group goutte
 */
class GoutteConnectorTest extends UnitTestCase {

  /**
   * Short description for $massager.
   *
   * @var \Drupal\goutte\GoutteConnector
   */
  protected $goutte;

  /**
   * Before a test method is run, setUp() is invoked.
   *
   * Create new goutte object.
   */
  public function setUp() {
    $this->goutte = new GoutteConnector();
  }

  /**
   * @covers Drupal\goutte\GoutteConnector::connect
   */
  public function testConnect() {
    $input = 'https://www.opin.ca';
    $expected = TRUE;
    $output = '';

    $output = $this->goutte->connect($input);
    $this->assertEquals($expected, $output);
  }

  /**
   * @covers Drupal\goutte\GoutteConnector::hasNodes
   */
  public function testHasNodes() {
    $input = 'https://www.opin.ca';
    $expected = TRUE;
    $output = '';

    $this->goutte->connect($input);
    $output = $this->goutte->hasNodes($input);
    $this->assertEquals($expected, $output);
  }

  /**
   * Whether it succeeded or failed, tearDown() will be invoked.
   *
   * Unset the $goutte object.
   */
  public function tearDown() {
    unset($this->goutte);
  }

}
