<?php

namespace Drupal\Tests\goutte\unit;

use Drupal\Tests\UnitTestCase;
use Drupal\goutte\NodeNormalizer;

/**
 * Simple test to ensure that asserts pass.
 *
 * @group goutte
 */
class NodeNormalizerTest extends UnitTestCase {

  /**
   * Short description for $normalizer.
   *
   * @var Drupal\goutte\NodeNormalizer
   */
  protected $normalizer;

  /**
   * Before a test method is run, setUp() is invoked.
   *
   * Create new unit object.
   */
  public function setUp() {
    $this->normalizer = new NodeNormalizer();
  }

  /**
   * @covers Drupal\goutte\NodeNormalizer::normalizeTitle
   */
  public function testScrubTitle() {
    $input = 'Bacon ipsum dolor amet brisket meatball pork, salami andouille landjaeger turkey. Ground round burgdoggen brisket ribeye bresaola. Chicken sirloin frankfurter, jowl pork loin strip steak burgdoggen filet mignon buffalo meatball. Bresaola shank swine meatloaf.';
    $expected = 'Bacon ipsum dolor amet brisket meatball pork, salami andouille landjaeger turkey. Ground round burgdoggen brisket ribeye bresaola. Chicken sirloin frankfurter, jowl pork loin strip steak burgdoggen filet mignon buffalo meatball. Bresaola shank swine ';
    $output = '';

    $output = $this->normalizer->normalizeTitle($input);
    $this->assertEquals($expected, $output);
  }

  /**
   * @covers Drupal\goutte\NodeNormalizer::normalizeTitle
   */
  public function testScrubTitleLength() {
    $input = 'Bacon ipsum dolor amet brisket meatball pork, salami andouille landjaeger turkey. Ground round burgdoggen brisket ribeye bresaola. Chicken sirloin frankfurter, jowl pork loin strip steak burgdoggen filet mignon buffalo meatball. Bresaola shank swine meatloaf.';
    $expected = 250;
    $output = '';

    $output = $this->normalizer->normalizeTitle($input);
    $this->assertLessThanOrEqual($expected, strlen($output));
  }

  /**
   * @covers Drupal\goutte\NodeNormalizer::normalizeSummary
   */
  public function testSummaryTextarea() {
    $input = '<div class="as"><p>By Louise Kinross</p><h1>Welcome to the page</h1><p>Bacon ipsum dolor amet brisket meatball pork, salami andouille landjaeger turkey.</p></div>';
    $expected = 'By Louise KinrossWelcome to the pageBacon ipsum dolor amet brisket meatball pork, salami andouille landjaeger turkey....';
    $output = '';

    $output = $this->normalizer->normalizeSummary($input);
    $this->assertEquals($expected, $output);
  }

  /**
   * @covers Drupal\goutte\NodeNormalizer::normalizeSummary
   */
  public function testSummaryTextareaLength() {
    $input = '<div class="as"><p>By Louise Kinross</p><h1>Welcome to the page</h1><p>Bacon ipsum dolor amet brisket meatball pork, salami andouille landjaeger turkey.</p></div>';
    $expected = 140;
    $output = '';

    $output = $this->normalizer->normalizeSummary($input);
    $this->assertLessThanOrEqual($expected, strlen($output));
  }

  /**
   * @covers Drupal\goutte\NodeNormalizer::normalizeDate
   */
  public function testConvertDate() {
    $input = 'November 28, 2019';
    $expected = '2019-11-28T00:00:00';
    $output = '';

    $output = $this->normalizer->normalizeDateField($input);
    $this->assertEquals($expected, $output);
  }

  /**
   * @covers Drupal\goutte\NodeNormalizer::normalizeDate
   */
  public function testConvertDateUnix() {
    $input = 'November 28, 2019';
    $expected = '1574859600';
    $output = '';

    $output = $this->normalizer->normalizeDate($input);
    $this->assertEquals($expected, $output);
  }

  /**
   * Whether it succeeded or failed, tearDown() will be invoked.
   *
   * Unset the $unit object.
   */
  public function tearDown() {
    unset($this->massager);
  }

}
