<?php

namespace Drupal\datamediaparent\Controller;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\State\StateInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\media\Entity\Media;
use Drupal\file\Entity\File;
use Drupal\Core\Datetime\DrupalDateTime;
use Drupal\Core\Datetime;

class DatamediaparentController extends ControllerBase {
    
    public function content() {
                        
        $result=[];
                        
                         
        $mtitle = \Drupal::request()->query->get('title');
        $name = \Drupal::request()->query->get('name');
         $mlimit = \Drupal::request()->query->get('mlimit');
        $mtimeraw = \Drupal::request()->query->get('createdate');
        $category = \Drupal::request()->query->get('category');
                        
       $database = \Drupal::database();
       $timefiled = new DrupalDateTime($mtimeraw);
      $times = strtotime($mtimeraw);
      
       $timefiledraw = $timefiled->format(\Drupal\datetime\Plugin\Field\FieldType\DateTimeItemInterface::DATETIME_STORAGE_FORMAT);
      // echo $timefiledraw;
      
       $ids = \Drupal::entityQuery('media')->accessCheck(TRUE);
       $ids->condition('field_media_in_library', '1');
       $ids->condition('bundle', 'image');
       $ids->condition('status', '1');
       if($mtitle){
                $ids->condition('name', "%" . $database->escapeLike($mtitle) . "%", 'LIKE');
                //$ids->condition('uri', "%" . $database->escapeLike($mtitle) . "%", 'LIKE');
                $ids->sort('created', 'DESC');
               //  ->condition('created', $weekAgo, '>=')
               //  ->range(0, $mlimit)
       }
        if( $mlimit){
               // ->condition('name', "%" . $database->escapeLike($mtitle) . "%", 'LIKE')
                $ids->sort('created', 'DESC');
                 //->condition('created', $weekAgo, '>=')
                $ids ->range(0, $mlimit);
       }
        if( $mtimeraw){
             //   ->condition('name', "%" . $database->escapeLike($mtitle) . "%", 'LIKE')
                $ids->sort('created', 'DESC');
                $ids ->condition('created', $times , '>=');
               //  ->range(0, $mlimit)
       }
       if( $category){
             //   ->condition('name', "%" . $database->escapeLike($mtitle) . "%", 'LIKE')
                $image_category = array_keys(\Drupal::entityQuery("taxonomy_term")->condition("vid", "image_category")->condition("name", $category)->execute());
                
                $ids ->condition('field_image_category', $image_category[0], '=');
               //  ->range(0, $mlimit)
       }
       
        $result_id = $ids->execute();
       
            $medias = Media::loadMultiple($result_id);

           foreach($medias as $mediasvalue){
                     
               
                $current_timeset = $mediasvalue->get('created')->getValue();
              // echo $mediasvalue->get('created')->getValue(),
                
              $current_time =   implode(' ',$current_timeset[0]);
           //echo $current_time;
           // echo '<br>';
               $date_output = date('m/d/Y', $current_time);
              // echo date('m/d/Y H:i:s', 1666366132);
               //echo $date_output;
            $image_name = $mediasvalue->get('image')->entity->filename->value;

            if ($name) {
              if (str_contains(strtolower($image_name), strtolower($name))) {
                $result[] =[
                      
                        'name'=>  $mediasvalue->get('name')->getValue(),
                      
                        'Imagedata'=> \Drupal::service('file_url_generator')->generateAbsoluteString($mediasvalue->get('image')->entity->getFileUri()) ,
                        'Bundle'=> $mediasvalue->get('bundle')->getValue(),
                        'langcode'=> $mediasvalue->get('langcode')->getValue(),
                        'thumbnail'=>$mediasvalue->get('thumbnail')->getValue(),
                        'created'=>$mediasvalue->get('created')->getValue(),
                        'formateddate'=>$date_output,
                        'changed'=>$mediasvalue->get('changed')->getValue(),
                        
                        
                       ];
              }
            }
            else {
              $result[] =[
                      
                        'name'=>  $mediasvalue->get('name')->getValue(),
                      
                        'Imagedata'=> \Drupal::service('file_url_generator')->generateAbsoluteString($mediasvalue->get('image')->entity->getFileUri()) ,
                        'Bundle'=> $mediasvalue->get('bundle')->getValue(),
                        'langcode'=> $mediasvalue->get('langcode')->getValue(),
                        'thumbnail'=>$mediasvalue->get('thumbnail')->getValue(),
                        'created'=>$mediasvalue->get('created')->getValue(),
                        'formateddate'=>$date_output,
                        'changed'=>$mediasvalue->get('changed')->getValue(),
                        
                        
                       ];
            }
            
             
                       
           } 
           
           if(empty($result)) {
               $result = ["no result"];
           }
           return new JsonResponse($result);
    }

    
}
    
    
    
    
    
    
    


