<?php
namespace Drupal\w3c_media_update\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\media\Entity\Media;
use Drupal\file\Entity\File;
use Drupal\node\Entity\Node;

class MediaUpdateController extends ControllerBase {
    /**
    * {@inheritdoc}
    */
    public function content() {
        // Image slide paragraph
        $query = \Drupal::database()->select('paragraph__field_slider_image', 'n')
            ->fields('n');
        $results = $query->execute()->fetchAll();
        
        foreach ($results as $result) {
            
            $nid = $result->entity_id;
            $p = \Drupal\paragraphs\Entity\Paragraph::load( $nid );
            $image_media = Media::create([
              'name' => $result->field_slider_image_alt,
              'bundle' => 'image',
              'uid' => 1,
              'langcode' => 'en',
              'status' => 1,
              'image' => [
                'target_id' => $result->field_slider_image_target_id,
                'alt' => $result->field_slider_image_alt,
                'title' => $result->field_slider_image_alt,
              ],
            ]);
            $image_media->save();
            
            $p->set("field_slider_image_media", array('target_id'=>$image_media->id()));
            $p->save();
        }
        
        // Landing Page
        $query = \Drupal::database()->select('node__field_hero_image', 'n')
            ->fields('n');
        $results = $query->execute()->fetchAll();
        
        foreach ($results as $result) {
            
            $nid = $result->entity_id;
            $node = Node::load($nid);
            
            $image_media = Media::create([
              'name' => $result->field_hero_image_alt,
              'bundle' => 'image',
              'uid' => 1,
              'langcode' => 'en',
              'status' => 1,
              'image' => [
                'target_id' => $result->field_hero_image_target_id,
                'alt' => $result->field_hero_image_alt,
                'title' => $result->field_hero_image_alt,
              ],
            ]);
            $image_media->save();
            
            $node->set("field_hero_image_media", array('target_id'=>$image_media->id()));
            $node->save();
        }
        
        // Schools page
        $query = \Drupal::database()->select('node__field_school_building_image', 'n')
            ->fields('n');
        $results1 = $query->execute()->fetchAll();
        
        foreach ($results1 as $result) {
           
            $nid = $result->entity_id;
            $node = Node::load($nid);
            
            $image_media = Media::create([
              'name' => $result->field_school_building_image_alt,
              'bundle' => 'image',
              'uid' => 1,
              'langcode' => 'en',
              'status' => 1,
              'image' => [
                'target_id' => $result->field_school_building_image_target_id,
                'alt' => $result->field_school_building_image_alt,
                'title' => $result->field_school_building_image_alt,
              ],
            ]);
            $image_media->save();
            $node->set("field_school_building_image_medi", array('target_id'=>$image_media->id()));
            $node->save();
        }
        echo "All Media Updated."; die;
    }

}