<?php

namespace Drupal\york_google_calendar_sync\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\node\Entity\Node;

/**
 * Class EventsForm extends FormBase.
 */
class EventsForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'events_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

    // // Get the data:
    $events = $_SESSION['york_google_calendar_sync']['york_events'];

    foreach ($events as $event) {
      $eventSummary = $event->getSummary();
      $eventDescription = urlencode($event->getDescription());
      $validEvent = strpos($eventSummary, "Event");
      if ($validEvent !== 0) {
        // Yes this is 0. This means it did not find the string in any position.
        continue;
      };

      $start = $event->start->dateTime;
      if (empty($start)) {
        $start = $event->start->date;
      }
      $end = $event->end->dateTime;
      if (empty($end)) {
        $end = $event->end->date;
      }

      $formatedStartDate = strtotime($start);
      $formatedEndDate = strtotime($end);
      $summaryWithDate = $eventSummary . ' on ' . date('Y-m-d', $formatedStartDate);
      ;
      $eventId = $event->getID() . "::" . $eventSummary . "::" . $formatedStartDate . "::" . $formatedEndDate . "::" . $eventDescription;
      $eventInfo[$eventId] = $summaryWithDate;
    }
    $form['calendar_events'] = [
      '#type' => 'checkboxes',
      '#options' => $eventInfo,
      '#title' => $this->t('Selected Events will be imported.'),
      '#default_value' => array_keys($eventInfo),
    ];

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Import selected Events'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $eventsToImport = $form_state->getValue('calendar_events');
    $drupalExistingEvents = $this->getAllEvents();

    $updatedCount = 0;
    $addedCount = 0;
    foreach ($eventsToImport as $key => $val) {

      $parseThis = explode("::", $val);
      $field_google_event_uuid = $parseThis[0];
      $title = $parseThis[1];
      $startDateTime = date('Y-m-d\TH:i:s', $parseThis[2]);
      $endDateTime = date('Y-m-d\TH:i:s', $parseThis[3]);
      $eventDescription = $parseThis[4];

      $existingKey = array_search($field_google_event_uuid, $drupalExistingEvents);
      if ($existingKey) {
        Node::load($existingKey)->delete();
        $updatedCount++;
      }

      if ($field_google_event_uuid) {

        $addEvent = [
          'type'        => 'events',
          'title'       => $title,
          'field_google_event_uuid' => $field_google_event_uuid,
          'moderation_state' => 'published',
          'field_start_time_date_end_time_d' =>
          ['value' => $startDateTime, 'end_value' => $endDateTime],
          'body' => urldecode($eventDescription),
        ];
        // Add Event.
        $node = Node::create($addEvent);
        $saveNode = $node->save();
        $addedCount++;
      }
    }
    $addedCount = $addedCount - $updatedCount;
    $this->messenger()->addStatus($addedCount . " have been added");
    $this->messenger()->addStatus($updatedCount . " have been updated");
    $form_state->setRedirect('york_google_calendar_sync.settings_form');
  }

  /**
   * {@inheritdoc}
   */
  public function getAllEvents() {
    $nids = \Drupal::entityQuery('node')->condition('type', 'events')->execute();
    $nodes = Node::loadMultiple($nids);
    foreach ($nodes as $node) {

      if ($node->get('field_google_event_uuid')->getValue()[0]['value']) {
        $node_id = $node->get('nid')->getValue()[0]['value'];
        $google_id = $node->get('field_google_event_uuid')->getValue()[0]['value'];
        $drupalExistingEvents[$node_id] = $google_id;
      }
    }

    return $drupalExistingEvents;
  }

}
