<?php

namespace Drupal\york_live_tweets\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a form for changing Consumer API Keys and Access Tokens.
 */
class YorkLiveTweetsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'york_live_tweets_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'york_live_tweets.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('york_live_tweets.settings');
    $york_live_tweets_screen_name = $config->get('york_live_tweets_screen_name');
    $york_live_tweets_number_of_tweets = $config->get('york_live_tweets_number_of_tweets');
    $york_live_tweets_api_key = $config->get('york_live_tweets_api_key');
    $york_live_tweets_api_skey = $config->get('york_live_tweets_api_skey');
    $york_live_tweets_acc_token = $config->get('york_live_tweets_acc_token');
    $york_live_tweets_acc_stoken = $config->get('york_live_tweets_acc_stoken');

    $form['york_live_tweets_screen_name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Screen Name'),
      '#default_value' => isset($york_live_tweets_screen_name) ? $york_live_tweets_screen_name : '',
      '#required' => TRUE,
      '#prefix' => '@',
    ];

    $form['york_live_tweets_number_of_tweets'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Max Number of Tweets to show'),
      '#default_value' => isset($york_live_tweets_number_of_tweets) ? $york_live_tweets_number_of_tweets : '4',
      '#required' => TRUE,
      '#maxlength' => 2,
    ];

    $form['york_live_tweets_api_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API Key'),
      '#default_value' => isset($york_live_tweets_api_key) ? $york_live_tweets_api_key : '',
      '#required' => TRUE,
    ];

    $form['york_live_tweets_api_skey'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API Secret Key'),
      '#default_value' => isset($york_live_tweets_api_skey) ? $york_live_tweets_api_skey : '',
      '#required' => TRUE,
    ];

    $form['york_live_tweets_acc_token'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Access Token'),
      '#default_value' => isset($york_live_tweets_acc_token) ? $york_live_tweets_acc_token : '',
      '#required' => TRUE,
    ];

    $form['york_live_tweets_acc_stoken'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Access Token (Secret)'),
      '#default_value' => isset($york_live_tweets_acc_stoken) ? $york_live_tweets_acc_stoken : '',
      '#required' => TRUE,
    ];

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Save'),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();

    \Drupal::configFactory()->getEditable('york_live_tweets.settings')
      ->set('york_live_tweets_screen_name', $values['york_live_tweets_screen_name'])
      ->set('york_live_tweets_number_of_tweets', $values['york_live_tweets_number_of_tweets'])
      ->set('york_live_tweets_api_key', $values['york_live_tweets_api_key'])
      ->set('york_live_tweets_api_skey', $values['york_live_tweets_api_skey'])
      ->set('york_live_tweets_acc_token', $values['york_live_tweets_acc_token'])
      ->set('york_live_tweets_acc_stoken', $values['york_live_tweets_acc_stoken'])->save();

    drupal_set_message(t('Consumer API Keys and Access Tokens have been updated.'), 'status');
  }

}
