<?php
namespace Drupal\york_misc\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Form\ConfigFormBase;
use Symfony\Component\HttpFoundation\RedirectResponse;

class CustomCacheCleanController extends ControllerBase {
    /**
    * {@inheritdoc}
    */
    public function content() {
        
        //To get another database (here : 'second')
        $con = \Drupal\Core\Database\Database::getConnection('default','second');
        
        //To set the active connection
        $conn = \Drupal\Core\Database\Database::setActiveConnection('second');
        
        
        $data = $con->select('cache_clean','d')->fields('d')->condition('status', 0)->execute()->fetchAll();
        
        foreach ($data as $school) {
            $ch = curl_init();
            $headers = array(
            'Accept: application/json',
            'Content-Type: application/json',
        
            );
            
            if (strpos($school->domain,'http') !== false) {
                $school_name = str_replace("http", "https", $school->domain);
            }

            $url = $school_name . "/custom_cache_clean";

            $data = ['q' => 'aa'];
            
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_HEADER, 0);
        
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET"); 
        
            // Timeout in seconds
            curl_setopt($ch, CURLOPT_TIMEOUT, 60);
            
            curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:11.0) Gecko/20100101 Firefox/11.0"); 
            $cookie_file = "cookies.txt";
            curl_setopt($ch, CURLOPT_COOKIESESSION, true);
            curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie_file);
            curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie_file);
        
            $response = curl_exec($ch);
        
            $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        
            curl_close($ch);
            
            $con->update('cache_clean')
            ->fields(array(
                'status' => 1,
            ))
            ->condition('id', $school->id)
            ->execute();
        }
        
        $response = new RedirectResponse('/');
        $response->send();
    }
    
    public function force() {
        
        //To get another database (here : 'second')
        $con = \Drupal\Core\Database\Database::getConnection('default','second');
        
        //To set the active connection
        $conn = \Drupal\Core\Database\Database::setActiveConnection('second');
        
        
        $data = $con->select('cache_clean','d')->fields('d')->execute()->fetchAll();
        
        foreach ($data as $school) {
            $ch = curl_init();
            $headers = array(
            'Accept: application/json',
            'Content-Type: application/json',
        
            );
            if (strpos($school->domain,'http') !== false) {
                $school_name = str_replace("http", "https", $school->domain);
            }

            $url = $school_name . "/custom_cache_clean";

            $data = ['q' => 'aa'];
            
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_HEADER, 0);
        
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET"); 
        
            // Timeout in seconds
            curl_setopt($ch, CURLOPT_TIMEOUT, 60);
            
            curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:11.0) Gecko/20100101 Firefox/11.0"); 
            $cookie_file = "cookies.txt";
            curl_setopt($ch, CURLOPT_COOKIESESSION, true);
            curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie_file);
            curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie_file);
        
            $response = curl_exec($ch);
        
            $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        
            curl_close($ch);
            
            $con->update('cache_clean')
            ->fields(array(
                'status' => 1,
            ))
            ->condition('id', $school->id)
            ->execute();
        }
        
        $response = new RedirectResponse('/');
        $response->send();
    }

}