<?php
namespace Drupal\york_misc\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\State\StateInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\media\Entity\Media;
use Drupal\file\Entity\File;
use Drupal\node\Entity\Node;

class CustomSearch extends ControllerBase {
    /**
    * {@inheritdoc}
    */
    public function content() {
        $index = \Drupal\search_api\Entity\Index::load('solr');
        
        $query = $index->query();
        
        //dump($query); die;
        // Change the parse mode for the search.
        // $parse_mode = \Drupal::service('plugin.manager.search_api.parse_mode')->createInstance('direct');
        // $parse_mode->setConjunction('OR');
        // $query->setParseMode($parse_mode);
        
        $key = $_GET['key'];
        // Set fulltext search keywords and fields.
        $query->keys($key);
        $query->setFulltextFields(['title', 'name_1', 'processed', 'summary', 'type']);
        
        // Set additional conditions.
        $query->addCondition('status', 1);
        
        if (isset($_GET['type']) && $_GET['type'] != 'All') {
            $query->addCondition('type', $_GET['type']);
        }
        // Add more complex conditions.
        // (In this case, a condition for a specific datasource).
        // $time = \Drupal::service('datetime.time')->getRequestTime();
        // $conditions = $query->createConditionGroup('OR');
        // $conditions->addCondition('search_api_datasource', 'entity:node', '<>')
        //   ->addCondition('created', $time - 7 * 24 * 3600, '>=');
        // $query->addConditionGroup($conditions);
        
        // // Restrict the search to specific languages.
        // $query->setLanguages(['de', 'it']);
        
        // Do paging.
        // if(isset($_GET['limit'])) {
        //     $limit = $_GET['limit'];
        //     $start_limit = $limit - 10;
        // }
        // else {
        //     $limit = '10';
        //     $start_limit = $limit - 10;
        // }

        //$query->range($start_limit, $limit);
        
        // Add sorting.
        //$query->sort('search_api_relevance', 'DESC');
        
        // Set additional options.
        // (In this case, retrieve facets, if supported by the backend.)
        // $server = $index->getServerInstance();
        // if ($server->supportsFeature('search_api_facets')) {
        //   $query->setOption('search_api_facets', [
        //     'type' => [
        //       'field' => 'type',
        //       'limit' => 20,
        //       'operator' => 'and',
        //       'min_count' => 1,
        //       'missing' => TRUE,
        //     ],
        //   ]);
        // }
        
        // Set one or more tags for the query.
        // @see hook_search_api_query_TAG_alter()
        // @see hook_search_api_results_TAG_alter()
        //$query->addTag('custom_search');
        
        // Execute the search.
        $results = $query->execute();
        
        $ids = array_keys($results->getResultItems());
        return new JsonResponse([ 'data' => $results->getExtraData("elasticsearch_response", []), 'method' => 'GET', 'status'=> 200]);
        //dump($results->getExtraData("elasticsearch_response", [][])); die;
        if(!empty($ids)) {
            $i = 0;
            foreach ($ids as $id) {
                $nid = explode('/', $id);
                $final_nid = str_replace(':en', '', $nid[1]);
                $node = Node::load($final_nid);
                $data[$i]['title'] = $node->getTitle();
                $data[$i]['description'] = $node->body->value;
                $data[$i]['date'] = date('F d, Y', $node->created->value);
                global $base_url;
                $data[$i]['url'] = $base_url . \Drupal::service('path_alias.manager')->getAliasByPath('/node/'.$final_nid);;
                $i++;
            }
        }
        else {
            $data['error'] = 'There is no result found. Please try with different Keyword.';
        }
        return new JsonResponse([ 'data' => $data, 'method' => 'GET', 'status'=> 200]);
        echo "<pre>"; dump($data); die;
        echo "Returned IDs: $ids.\n";
        $facets = $results->getExtraData('search_api_facets', []);
        
        echo 'Facets data: ' . var_export($facets, TRUE); die;
        // $db = \Drupal::database();
        // $db->delete('datashare_list')->condition('type', 'alert')->execute();
        
        // $query = \Drupal::database()->select('a_test', 'n')
        //     ->fields('n');
        // $results = $query->execute()->fetchAll();
        
        // foreach ($results as $values) {
        //   $termId= \Drupal::entityQuery("taxonomy_term")->condition("vid", "event")->condition("name", $values->field_event)->execute();
        //     //$node = Node::load(2884);
        //     //dump($node); die;
        //     $results1 = 
        //     $query1 = \Drupal::database()->select('node_field_data', 'n')
        //         ->fields('n')
        //         ->condition('n.title', $values->title);
        //     $query1->join('node__field_start_time_date_end_time_d', 'nfd', 'n.nid = nfd.entity_id');
        //     $query1->condition('nfd.field_start_time_date_end_time_d_value', date('Y-m-d\Th:i:s', strtotime($values->field_start_time_date_end_time_d)));
        //     $results1 = $query1->execute()->fetchAll();
        //     if(empty($results1)) {
        //         $node = Node::create(array(
        //           'type' => 'events',
        //           'title' => $values->title,
        //           'langcode' => 'en',
        //           'uid' => '1',
        //           'status' => 1,
        //           'body' => $values->body,
        //           'field_contact' => $values->field_contact,
        //           'field_google_event_uuid' => $values->field_google_event_uuid,
        //           'field_event' => key($termId),
        //           'field_location' => $values->field_location,
        //           'field_remote_video_images' => $values->field_remote_video_images,
        //           'field_price' => $values->field_price,
        //           'field_public' => $values->field_public,
        //           'field_room' => $values->field_room,
        //           'field_seats_available' => $values->field_seats_available,
        //           'field_tag' => $values->field_tag,
        //           'field_image_hero' => $values->field_image_hero,
        //           'field_start_time_date_end_time_d' => [
        //             'value'=> date('Y-m-d\Th:i:s', strtotime($values->field_start_time_date_end_time_d)),
        //             'end_value' =>  date('Y-m-d\Th:i:s', strtotime($values->end_date)),
        //           ],
        //           'field_start_date' => date('Y-m-d', strtotime($values->start_date)),
        //           'field_end_date' => date('Y-m-d', strtotime($values->end_date)),
        //         ));
        //         $node->set('moderation_state', "published");
        //       // $node->set('field_start_time_date_end_time_d', ["value" => $values->field_start_time_date_end_time_d, "end_value" => $values->end_date]);
        //         $node->save();
        //     }
        // }
        // echo "All events added"; die;
        // dump($alert); die;
    }

}