<?php
namespace Drupal\york_misc\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\media\Entity\Media;
use Drupal\file\Entity\File;
use Drupal\node\Entity\Node;
use Symfony\Component\HttpFoundation\RedirectResponse;

class DeleteFileController extends ControllerBase {
    /**
    * {@inheritdoc}
    */
    public function deleteabout() {
        $nid = \Drupal::request()->query->get('nid');
        $fid = \Drupal::request()->query->get('fid');
        $file = File::load($fid);
        $node = Node::load($nid);
        $node->set('field_about_us_image', '');
        $node->save();
        $file->delete();
        global $base_url;
        $url = $base_url . "/node/".$nid."/edit#edit-field-about-us-image-wrapper";
        $redirect = new RedirectResponse($url);
        $redirect->send();
        return [
          '#markup' => $this->t(''),
        ];
    }
    
    /**
    * {@inheritdoc}
    */
    public function deletemap() {
        $nid = \Drupal::request()->query->get('nid');
        $fid = \Drupal::request()->query->get('fid');
        $file = File::load($fid);
        $node = Node::load($nid);
        $node->set('field_map_image', '');
        $node->save();
        $file->delete();
        global $base_url;
        $url = $base_url . "/node/".$nid."/edit#edit-field-map-image-wrapper";
        $redirect = new RedirectResponse($url);
        $redirect->send();
        return [
          '#markup' => $this->t(''),
        ];
    }

}