<?php
namespace Drupal\york_misc\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\State\StateInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\media\Entity\Media;
use Drupal\file\Entity\File;
use Drupal\node\Entity\Node;

class SchoolDataController extends ControllerBase {
    /**
    * {@inheritdoc}
    */
    public function content() {
        
        // $db = \Drupal::database();
        // $db->delete('datashare_list')->condition('type', 'alert')->execute();
        
        $query = \Drupal::database()->select('node_field_data', 'n')
                ->fields('n', ['nid'])
                ->condition('n.type', "schools");
        $results = $query->execute()->fetchAll();
        
        foreach ($results as $values) {
            
            $node = Node::load($values->nid);
            
            foreach ($node->getFields() as $name => $field) {
                switch ($name) {
                  case "body":
                    $allFields[$name] = $node->get('body')->getValue()[0]['value'];
                    break;
                  case "field_municipality":
                    $term_name = \Drupal\taxonomy\Entity\Term::load($field->getString())->get('name')->value;
                    $allFields[$name] = $term_name;
                    break;
                    
                  case "field_tag":
                    if (!empty($field->getString())) {
                        $term_name = \Drupal\taxonomy\Entity\Term::load($field->getString());
                        if (!empty($term_name)) {
                            $term_name = $term_name->get('name')->value;
                        }
                    }
                    $allFields[$name] = $term_name;
                    break;
    
                  case "field_school_building_image_medi":
                    $file1 = $node->get('field_school_building_image_medi')->getValue()[0]['target_id'];
                    $media = Media::load($file1);
                    
                    $fid = $media->image->target_id;
                    $file2 = File::load($fid);
                    
                    if (!empty($file2)) {
                        $uri = $file2->getFileUri();
                        $url = \Drupal\Core\Url::fromUri(\Drupal::service('file_url_generator')->generateAbsoluteString($uri))->toString();
                        $allFields[$name] = $url;
                    }
                    else {
                        $allFields[$name] = '';
                    }
                    break;
                    
                  case "field_principal":
                    $data = $node->get('field_principal')->getValue()[0]['value'];
                    $allFields[$name] = $data;
                    break;
                    
                  case "field_principal_email":
                    $data = $node->get('field_principal_email')->getValue()[0]['value'];
                    $allFields[$name] = $data;
                    break;
                    
                  case "field_vice_principal":
                    $data = $node->get('field_vice_principal')->getValue()[0]['value'];
                    $allFields[$name] = $data;
                    break;
                    
                  case "field_vice_principal_email":
                    $data = $node->get('field_vice_principal_email')->getValue()[0]['value'];
                    $allFields[$name] = $data;
                    break;
                    
                  case "field_superintendent":
                    $data = $node->get('field_superintendent')->getValue()[0]['value'];
                    $allFields[$name] = $data;
                    break;
                    
                  case "field_trustee":
                    $data = $node->get('field_trustee')->getValue()[0]['value'];
                    $allFields[$name] = $data;
                    break;
                    
                  case "field_bell_times":
                    $data = $node->get('field_bell_times')->getValue()[0]['value'];
                    $allFields[$name] = $data;
                    break;
                    
                  case "field_address":
                    $data = $node->get('field_address')->getValue();
                    $allFields[$name] = $data;
                    break;
                  
                  case "field_community":
                    $data = $node->get('field_community')->getValue();
                    $allFields[$name] = $data;
                    break;
                    
                  case "field_panel":
                    $data = $node->get('field_panel')->getValue();
                    $allFields[$name] = $data;
                    break;
                    
                  case "field_domain":
                    $data = $node->get('field_domain')->getValue();
                    $allFields[$name] = $data;
                    break;
                    
                  case "field_school_id":
                    $data = $node->get('field_school_id')->getValue();
                    $allFields[$name] = $data;
                    break;
                    
                  case "field_phone":
                    $data = $node->get('field_phone')->getValue();
                    $allFields[$name] = $data;
                    break;
                    
                  case "field_website_link":
                    // if(!empty($p->field_url[0]->uri)) {
                    //     $mylink = Url::fromUri($p->field_url[0]->uri);
                    //     $slide[$i]['link'] = $mylink->toString();
                    // }
                    $data = $node->get('field_website_link')->getValue();
                    $allFields[$name] = $data;
                    break;
                    
                    
                  default:
                    $allFields[$name] = $field->getString();
                }
            }
            
            //To get another database (here : 'second')
            $con = \Drupal\Core\Database\Database::getConnection('default','second');
            
            //To set the active connection
            $conn = \Drupal\Core\Database\Database::setActiveConnection('second');
            
            $data = $con->select('datashare_school','d')->fields('d')->condition('school_id', $node->id())->execute()->fetchAll();
            
            if (empty($data)) {
                $con->insert('datashare_school')
                    ->fields(array(
                        'school_id' => $node->id(),
                        'school_data' => json_encode($allFields),
                        'domain' => $allFields['field_website_link'][0]['uri'],
                  ))
                ->execute();
            }
            
        }
        echo "All school added."; die;
    }
    
    public function trustee_update() {
        
        // $db = \Drupal::database();
        // $db->delete('datashare_list')->condition('type', 'alert')->execute();
        
        $query = \Drupal::database()->select('node_field_data', 'n')
                ->fields('n', ['nid'])
                ->condition('n.type', "schools");
        $results = $query->execute()->fetchAll();
        
        foreach ($results as $values) {
            $node = Node::load($values->nid);
            
            $community = $node->field_trustee->value;

            if (!empty($community)) {
                $query = \Drupal::database()->select('node_field_data', 'n')
                    ->fields('n', ['nid'])
                    ->condition('n.type', "staff_profile")
                    ->condition('n.title', $community);
                $results = $query->execute()->fetchObject();
                
                if(!empty($results)) {
                    $node->set("field_trustee_new", $results->nid);
                    $node->save();
                }
            }
        }
        echo "All school trustee updated."; die;
    }

    public function staff_data() {
        
       // $db = \Drupal::database();
        // $db->delete('datashare_list')->condition('type', 'alert')->execute();
        
        $query = \Drupal::database()->select('node_field_data', 'n')
                ->fields('n', ['nid'])
                ->condition('n.type', "staff_profile");
        $query->join('node__field_staff_category', 's', 's.entity_id = n.nid');
        $query->condition('s.field_staff_category_target_id', '329');
        $results = $query->execute()->fetchAll();
        $i = 0;
        foreach ($results as $values) {
            
            $node = Node::load($values->nid);
            $data_output[$i]['nid'] = $values->nid;
            $data_output[$i]['trustee_message'] = $node->field_trustee_message->value;
            $data_output[$i]['title'] = $node->title->value;
            
            //To get another database (here : 'second')
            $con = \Drupal\Core\Database\Database::getConnection('default','second');
            
            //To set the active connection
            $conn = \Drupal\Core\Database\Database::setActiveConnection('second');
            
            $data = $con->select('datashare_staff','d')->fields('d')->condition('nid', $node->id())->execute()->fetchAll();
            
            if (empty($data)) {
                $con->insert('datashare_staff')
                    ->fields(array(
                        'nid' => $values->nid,
                        'data' => json_encode($data_output),
                  ))
                ->execute();
            }
            $i = $i++;
        }
        
        echo "All staff added."; die;
    }

}