<?php

namespace Drupal\york_misc\Plugin\Block;

/**
 * @file
 * Contains \Drupal\yrdsb_workflow\Plugin\Block\GoogleCalendarBlock4.
 */

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\user\Entity\User;
use Drupal\Component\Serialization\Json;
use Drupal\yrdsb_workflow\calendarapi;

/**
 * Provide wishlist block.
 *
 * @Block(
 *   id = "google_calendar_block4",
 *   admin_label = @Translation("Google Calendar block 4"),
 * )
 */
class GoogleCalendarBlock4 extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'google_calendar_block4';
  }

  /**
   * {@inheritdoc}
   */
  public function blockForm($form, FormStateInterface $form_state) {
    // $form = parent::blockForm($form, $form_state);
    // // Retrieve existing configuration for this block.
    // $config = $this->getConfiguration();

    // $form['school_google_calendar_account'] = [
    //   '#type' => 'textfield',
    //   '#title' => t('School Google Calendar Account'),
    //   '#default_value' => isset($config['school_google_calendar_account']) ? $config['school_google_calendar_account'] : '',
    // ];
    // $form['board_google_calendar_account'] = [
    //   '#type' => 'textfield',
    //   '#title' => t('Board Google Calendar Account'),
    //   '#default_value' => isset($config['board_google_calendar_account']) ? $config['board_google_calendar_account'] : '',
    // ];
     return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function blockSubmit($form, FormStateInterface $form_state) {
    // Save our custom settings when the form is submitted.
    //$this->setConfigurationValue('school_google_calendar_account', $form_state->getValue('school_google_calendar_account'));
    //$this->setConfigurationValue('board_google_calendar_account', $form_state->getValue('board_google_calendar_account'));
  }

  /**
   * {@inheritdoc}
   */
  public function build() {
    $db = \Drupal::database();
    $data = $db->select('datashare_list','d')
            ->fields('d')
            ->condition('type', 'calendar')
            ->execute()->fetchAll();
            
    
    $data = Json::decode($data[0]->data);
    
    $setting_config = \Drupal::config('yrdsb_workflows.settings');
    $config = $this->getConfiguration();
    
    $account = $setting_config->get('names_fieldset');
    unset($account['actions']);

    $items['google_calendar_api_key'] = $setting_config->get('google_calendar_api_key'); 
    $items['account'] = $account;
    
    foreach ($data['data']['data'] as $val) {
        if (isset($val['name'])) {
            $items['account'][] = $val;
        }
    }
    
    $conn = \Drupal::Database();
    $i = 0;
    foreach ($account as $acc) {
        
        // $result = $conn->select('a_test', 'a')
        //         ->fields('a')
        //         //->condition('a.end_date', array($start, $end), 'BETWEEN')
        //         //->condition('a.start_date',$start, '>=')
        //         ->condition('a.calendar_id', $acc['id'], '=')
        //         ->execute()
        //         ->fetchAll();
        $response[$i]['id'] = $acc['id'];
        $response[$i]['color'] = $acc['color'];
        if ($result) {
                foreach ($result as $row) {
                    
                    $response[$i]['events'][] = [
                        'id' => $row->calendar_id,
                        'title' => $row->title,
                        'description' => $row->body,
                        'start' => $row->start_date,
                        'end' => $row->end_date,
                        //'color' => $color[$row->calendar_id]
                    ];
                }
            }
        $i++;
    }

    // $items['board_google_calendar_account'] = $config['board_google_calendar_account'];
    return [
        '#theme' => 'google_calendar_block4',
        '#items' => (object) $items,
        '#data' => $items['account'],
        '#events' => $response,
        '#cache' => ['max-age' => 0],
        '#attached' => [
            'library' => [
              'yrdsb_workflow/global_styles',
            ],
          ],
    ];
  }

}
