<?php
namespace Drupal\york_school\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\node\Entity\Node;

class AddDomainController extends ControllerBase {
    /**
    * {@inheritdoc}
    */
    public function saveDomain() {
        $db = \Drupal::database();
        //To get another database (here : 'second')
        $con = \Drupal\Core\Database\Database::getConnection('default','second');
        
        //To set the active connection
        $conn = \Drupal\Core\Database\Database::setActiveConnection('second');
        
        $query = $con->select('school_data', 'n')
            ->fields('n');
        $results = $query->execute()->fetchAll();
        
        foreach ($results as $value) {
            $new_url = str_replace("-", ".", $value->new_url);
            $con = \Drupal\Core\Database\Database::getConnection('default','default');
    
            //To set the active connection
            $conn = \Drupal\Core\Database\Database::setActiveConnection('default');
            
            $query = $con->select('node__field_website_link', 'n')
            ->fields('n');
            $query->condition('n.field_website_link_uri', '%' . $con->escapeLike($new_url) . '%', 'LIKE');
            $results = $query->execute()->fetchAll();
            
            if (!empty($results)) {
                $node = Node::load($results[0]->entity_id);
                $node->set("field_domain", $value->new_url);
                $node->set("field_school_id", $value->school_id);
                $node->save();
            }
        }
        echo "School Domain added."; die;
        dump($results); die;
    }

}