<?php
namespace Drupal\york_school\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\State\StateInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\media\Entity\Media;
use Drupal\file\Entity\File;
use Drupal\node\Entity\Node;

class DatasaveController extends ControllerBase {
    /**
    * {@inheritdoc}
    */
    public function saveData() {
         $db = \Drupal::database();
         $db->delete('school_list')->execute();
        $query = \Drupal::database()->select('node_field_data', 'n')
            ->fields('n', ['title', 'nid']);
        $query->condition('n.type', 'schools');
        $results = $query->execute()->fetchAll();
        
        foreach ($results as $value) {
            $result = \Drupal::database()->insert('school_list')
              ->fields([
                'school_name' => $value->title,
                'nid' => $value->nid,
                'school_id' => $value->nid,
              ])
              ->execute();
        }
        echo "School list added."; die;
        dump($results); die;
    }

}