<?php
namespace Drupal\yrdsb_dashboard\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\State\StateInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\media\Entity\Media;
use Drupal\file\Entity\File;
use Drupal\node\Entity\Node;

class DashboardController extends ControllerBase {
    /**
    * {@inheritdoc}
    */
    public function content() {
        global $base_url;

        // return [
        //   '#markup' => $output,
        //   '#cache' => ['max-age' => 0],
        // ];
        
        $query = \Drupal::database()->select('node', 'n');
        $query->fields('n', ['nid']);
        $query->condition('n.type', 'slider');
        $result = $query->execute()->fetchAll();
        
        if (!empty($result)) {
            $items['slider'] = $base_url . "/node/".$result[0]->nid."/edit?destination=admin/dashboard"; 
        }
        else {
            $items['slider'] = $base_url . "/node/add/slider?destination=admin/dashboard"; 
        }
        
        return [
            '#theme' => 'dashboard_page',
            '#items' => $items,
            '#cache' => ['max-age' => 0],
        ];
    }

}