<?php

/**
 * @file
 * Contains Drupal\yrdsb_dashboard\Form\SettingsForm.
 */

namespace Drupal\yrdsb_dashboard\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class SettingsForm.
 *
 * @package Drupal\yrdsb_dashboard\Form
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'yrdsb_dashboard.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('yrdsb_dashboard.settings');
    $num_fields = $form_state->get('num_fields') ?? 1;
    
    $form['welcome'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Welcome Message'),
      '#default_value' => $config->get('welcome'),
    ];
    $form['welcome_description'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Welcome Description'),
      '#default_value' => $config->get('welcome_description'),
    ];
    
    $cta_link = $config->get('cta_link');

    $form['cta_link'] = [
      '#type' => 'fieldset',
      '#title' => $this->t(' CTA link'),
    ];
    $form['cta_link']['cta_link_1'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('CTA Link 1'),
    ];

    $form['cta_link']['cta_link_1']['title_1'] = [
      '#type' => 'textfield',
          '#title' => $this->t('Title'),
          '#default_value' => $cta_link['cta_link_1']['title_1'],
    ];
    $form['cta_link']['cta_link_1']['icon_1'] = [
      '#type' => 'textfield',
          '#title' => $this->t('Icon'),
          '#default_value' => $cta_link['cta_link_1']['icon_1'],
    ];
    $form['cta_link']['cta_link_1']['link_1'] = [
      '#type' => 'url',
        '#title' => $this->t('Link'),
        '#default_value' => $cta_link['cta_link_1']['link_1'],
    ];


    // CTA Link 2
    $form['cta_link']['cta_link_2'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('CTA Link 2'),
    ];

    $form['cta_link']['cta_link_2']['title_2'] = [
      '#type' => 'textfield',
          '#title' => $this->t('Title'),
          '#default_value' => $cta_link['cta_link_2']['title_2'],
    ];
    $form['cta_link']['cta_link_2']['icon_2'] = [
      '#type' => 'textfield',
          '#title' => $this->t('Icon'),
          '#default_value' => $cta_link['cta_link_2']['icon_2'],
    ];
    $form['cta_link']['cta_link_2']['link_2'] = [
      '#type' => 'url',
        '#title' => $this->t('Link'),
        '#default_value' => $cta_link['cta_link_2']['link_2'],
    ];

    // CTA Link 3

    $form['cta_link']['cta_link_3'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('CTA Link 3'),
    ];

    $form['cta_link']['cta_link_3']['title_3'] = [
      '#type' => 'textfield',
          '#title' => $this->t('Title'),
          '#default_value' => $cta_link['cta_link_3']['title_3'],
    ];
    $form['cta_link']['cta_link_3']['icon_3'] = [
      '#type' => 'textfield',
          '#title' => $this->t('Icon'),
          '#default_value' => $cta_link['cta_link_3']['icon_3'],
    ];
    $form['cta_link']['cta_link_3']['link_3'] = [
      '#type' => 'url',
        '#title' => $this->t('Link'),
        '#default_value' => $cta_link['cta_link_3']['link_3'],
    ];

     // CTA Link 4

     $form['cta_link']['cta_link_4'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('CTA Link 4'),
    ];

    $form['cta_link']['cta_link_4']['title_4'] = [
      '#type' => 'textfield',
          '#title' => $this->t('Title'),
          '#default_value' => $cta_link['cta_link_4']['title_4'],
    ];
    $form['cta_link']['cta_link_4']['icon_4'] = [
      '#type' => 'textfield',
          '#title' => $this->t('Icon'),
          '#default_value' => $cta_link['cta_link_4']['icon_4'],
    ];
    $form['cta_link']['cta_link_4']['link_4'] = [
      '#type' => 'url',
        '#title' => $this->t('Link'),
        '#default_value' => $cta_link['cta_link_4']['link_4'],
    ];
      // CTA Link 5

      $form['cta_link']['cta_link_5'] = [
        '#type' => 'fieldset',
        '#title' => $this->t('CTA Link 5'),
      ];
  
      $form['cta_link']['cta_link_5']['title_5'] = [
        '#type' => 'textfield',
            '#title' => $this->t('Title'),
            '#default_value' => $cta_link['cta_link_5']['title_5'],
      ];
      $form['cta_link']['cta_link_5']['icon_5'] = [
        '#type' => 'textfield',
            '#title' => $this->t('Icon'),
            '#default_value' => $cta_link['cta_link_5']['icon_5'],
      ];
      $form['cta_link']['cta_link_5']['link_5'] = [
        '#type' => 'url',
          '#title' => $this->t('Link'),
          '#default_value' => $cta_link['cta_link_5']['link_5'],
      ];
      // CTA Link 6

      $form['cta_link']['cta_link_6'] = [
        '#type' => 'fieldset',
        '#title' => $this->t('CTA Link 6'),
      ];
  
      $form['cta_link']['cta_link_6']['title_6'] = [
        '#type' => 'textfield',
            '#title' => $this->t('Title'),
            '#default_value' => $cta_link['cta_link_6']['title_6'],
      ];
      $form['cta_link']['cta_link_6']['icon_6'] = [
        '#type' => 'textfield',
            '#title' => $this->t('Icon'),
            '#default_value' => $cta_link['cta_link_6']['icon_6'],
      ];
      $form['cta_link']['cta_link_6']['link_6'] = [
        '#type' => 'url',
          '#title' => $this->t('Link'),
          '#default_value' => $cta_link['cta_link_6']['link_6'],
      ];

    

    if ($config->get('names_fieldset') == NULL) {
      $default_params = [];
    }
    else {
      $default_params = $config->get('names_fieldset');
      unset($default_params['actions']);
    }
    $name_field = $form_state->get('num_names') ? $form_state->get('num_names') : count($default_params);

    $form['#tree'] = TRUE;

    $form['names_fieldset'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Dashboard page menus'),
      '#prefix' => "<div id='names-fieldset-wrapper'>",
      '#suffix' => '</div>',
    ];

    if (empty($name_field)) {
      $form_state->set('num_names', 1);
      $name_field = $form_state->get('num_names', 1);
    }
    else {
         $form_state->set('num_names', $name_field);
    }

    for ($i = 0; $i < $name_field; $i++) {
      $j = $i + 1;

      $form['names_fieldset'][$i]['title'] = [
        '#type' => 'textfield',
        '#title' => $this->t('Menu '. $j),
        '#maxlength' => 255,
        '#default_value' => count($default_params) ? $default_params[$i]['title'] : "",
        '#size' => 64,
        //'#disabled' => $disable,
      ];
      $form['names_fieldset'][$i]['link'] = [
        '#type' => 'textfield',
        '#default_value' => count($default_params) ? $default_params[$i]['link'] : "",
        '#title' => $this->t('Link'),
        '#maxlength' => 255,
        '#size' => 64,
        //'#disabled' => $disable,
      ];
      $form['names_fieldset'][$i]['school_type'] = [
        '#type' => 'checkboxes',
        '#default_value' => !empty($default_params[$i]['school_type']) ? $default_params[$i]['school_type'] : "['secondary', 'elementary']",
        '#options' => ['secondary' => 'Secondary', 'elementary' => 'Elementary']
        //'#disabled' => $disable,
      ];
      
    }
    $form['names_fieldset']['actions'] = [
      '#type' => 'actions',
    ];
    $form['names_fieldset']['actions']['add_name'] = [
      '#type' => 'submit',
      '#value' => $this->t('Add one more'),
      '#submit' => ['::addOne'],
      '#ajax' => [
        'callback' => '::addmoreCallback',
        'wrapper' => "names-fieldset-wrapper",
      ],
    ];
    if ($form_state->get('num_names') > 1) {
      $form['names_fieldset']['actions']['remove_name'] = [
        '#type' => 'submit',
        '#value' => $this->t('Remove one'),
        '#submit' => ['::removeCallback'],
        '#ajax' => [
          'callback' => '::addmoreCallback',
          'wrapper' => "names-fieldset-wrapper",
        ],
      ];
    }
    
    $form['azure_login'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Azure Details'),
    ];
    
    // if (!empty($config->get('azure_login')['cilentId'])) {
    //     $cilentId = substr($config->get('azure_login')['cilentId'], -4);
    //     $cilentId = "-----------------------------" . $cilentId;
    // }
    // else {
    //     $cilentId = "";
    // }
    $form['azure_login']['cilentId'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Application (client) ID'),
      '#description' => $this->t('Enter a Application (client) ID. For ex. 7cacbe9f-a562-4841-9c0e-42617785fae3'),
      '#default_value' => $config->get('azure_login')['cilentId'],
    ];
    // if (!empty($config->get('azure_login')['tenantID'])) {
    //     $tenantID = substr($config->get('azure_login')['tenantID'], -4);
    //     $tenantID = "-----------------------------" . $tenantID;
    // }
    // else {
    //     $tenantID = "";
    // }
    $form['azure_login']['tenantID'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Directory (tenant) ID'),
      '#description' => $this->t('Enter a Directory (tenant) ID. For ex. b01c4e5e-95f9-4bb2-9f18-2469e29f5146'),
      '#default_value' => $config->get('azure_login')['tenantID'],
    ];
    
    // if (!empty($config->get('azure_login')['clientSecret'])) {
    //     $clientSecret = substr($config->get('azure_login')['clientSecret'], -4);
    //     $clientSecret = "-----------------------------" . $clientSecret;
    // }
    // else {
    //     $clientSecret = "";
    // }
    $form['azure_login']['clientSecret'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Secret Value'),
      '#description' => "Enter a Secret Value. For ex. j1P8Q~1T123cl_byTqNbLozVfrtdrvdfs6M8N7.Ybb~f",
      '#default_value' => $config->get('azure_login')['clientSecret'],
    ];
    
    // if (!empty($config->get('default_password'))) {
    //     $default_password = substr($config->get('default_password'), -4);
    //     $default_password = "-----------------------------" . $default_password;
    // }
    // else {
    //     $default_password = "";
    // }
    $form['azure_login']['default_password'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Default Password'),
      '#default_value' => $config->get('azure_login')['default_password'],
    ];
    
    // if (!empty($config->get('group_id'))) {
    //     $group_id = substr($config->get('group_id'), -4);
    //     $group_id = "-----------------------------" . $group_id;
    // }
    // else {
    //     $group_id = "";
    // }
    
    $form['azure_login']['group_id'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Group ID'),
      '#default_value' => $config->get('azure_login')['group_id'],
      '#description' => "Enter a Group ID. For ex. ff3cc60f-79bd-4766-b530-d1da86e373c0"
    ];
    
    $form['google_calendar'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Google Calendar'),
    ];
    
    $form['google_calendar']['google_calendar_api_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Google Calendar API key'),
      '#description' => $this->t('Enter a Google Calendar API key. For ex. AIzaSyDcnW6WejpTOCffshGDDb4neIrXVUA1EAE'),
      '#default_value' => $config->get('google_calendar')['google_calendar_api_key'],
    ];
    
    $form['board_events'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Board Events Link'),
      '#description' => $this->t('Enter a Board Events Link. For ex. https://www2.yrdsb.ca/calendar'),
      '#default_value' => $config->get('board_events'),
    ];

    $form_state->setCached(FALSE);
    
  


  
    return parent::buildForm($form, $form_state);
  }

 /**
   * Callback for both ajax-enabled buttons.
   *
   * Selects and returns the fieldset with the names in it.
   */
  public function addmoreCallback(array &$form, FormStateInterface $form_state) {
    return $form['names_fieldset'];
  }

  /**
   * Submit handler for the "add-one-more" button.
   *
   * Increments the max counter and causes a rebuild.
   */
  public function addOne(array &$form, FormStateInterface $form_state) {
    $name_field = $form_state->get('num_names');
    $add_button = $name_field + 1;
    $form_state->set('num_names', $add_button);
    $form_state->setRebuild();
  }

  /**
   * Submit handler for the "remove one" button.
   *
   * Decrements the max counter and causes a form rebuild.
   */
  public function removeCallback(array &$form, FormStateInterface $form_state) {
    $name_field = $form_state->get('num_names');
    if ($name_field > 1) {
      $remove_button = $name_field - 1;
      $form_state->set('num_names', $remove_button);
    }
    $form_state->setRebuild();
  }
  


  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    $values = $form_state->getValues();
    //To get another database (here : 'second')
        $con = \Drupal\Core\Database\Database::getConnection('default','second');
        
        //To set the active connection
        $conn = \Drupal\Core\Database\Database::setActiveConnection('second');
    $data = $con->delete('datashare_list')->condition('type', 'global')->execute();
    unset($values['op']);
    $con->insert('datashare_list')
        ->fields(array(
        'type' => "global",
        'data' => json_encode($values),
      ))
    ->execute();

    $this->config('yrdsb_dashboard.settings')
      ->set('welcome', $form_state->getValue('welcome'))
      ->set('welcome_description', $form_state->getValue('welcome_description'))
      ->set('cta_link', $form_state->getValue('cta_link'))
      ->set('azure_login', $form_state->getValue('azure_login'))
      ->set('google_calendar', $form_state->getValue('google_calendar'))
      ->set('board_events', $form_state->getValue('board_events'))
    //   ->set('cta_link_1', $form_state->getValue('cta_link_1'))
    //   ->set('cta_link_2', $form_state->getValue('cta_link_2'))
    //   ->set('cta_link_3', $form_state->getValue('cta_link_3'))
    //   ->set('cta_link_4', $form_state->getValue('cta_link_4'))
    //   ->set('cta_link_5', $form_state->getValue('cta_link_5'))
    //   ->set('cta_link_6', $form_state->getValue('cta_link_6'))
    //   ->set('title_1', $form_state->getValue('title_1'))
    //   ->set('title_2', $form_state->getValue('title_2'))
    //   ->set('title_3', $form_state->getValue('title_3'))
    //   ->set('title_4', $form_state->getValue('title_4'))
    //   ->set('title_5', $form_state->getValue('title_5'))
    //   ->set('title_6', $form_state->getValue('title_6'))
    //   ->set('icon_1', $form_state->getValue('icon_1'))
    //   ->set('icon_2', $form_state->getValue('icon_2'))
    //   ->set('icon_3', $form_state->getValue('icon_3'))
    //   ->set('icon_4', $form_state->getValue('icon_4'))
    //   ->set('icon_5', $form_state->getValue('icon_5'))
    //   ->set('icon_6', $form_state->getValue('icon_6'))
    //   ->set('link_1', $form_state->getValue('link_1'))
    //   ->set('link_2', $form_state->getValue('link_2'))
    //   ->set('link_3', $form_state->getValue('link_3'))
    //   ->set('link_4', $form_state->getValue('link_4'))
    //   ->set('link_5', $form_state->getValue('link_5'))
    //   ->set('link_6', $form_state->getValue('link_6'))
     
       ->set('names_fieldset', $form_state->getValue('names_fieldset'))
      
      ->save();
    
    //To get another database (here : 'second')
    $con = \Drupal\Core\Database\Database::getConnection('default','default');
    
    $data1 = $con->select('node_field_data','d');
            $data1->fields('d', ['nid', 'title']);
            $data1->condition('type', 'schools');
    $data1->join('node__field_website_link', 'n', 'd.nid = n.entity_id');
    $data1->fields('n', ['field_website_link_uri']);
    $result_data = $data1->execute()->fetchAll();
    
    //To get another database (here : 'second')
    $con = \Drupal\Core\Database\Database::getConnection('default','second');
    
    //To set the active connection
    $conn = \Drupal\Core\Database\Database::setActiveConnection('second');
    
    foreach ($result_data as $da) {
        $data = $con->select('cache_clean','d')->fields('d')->condition('nid', $da->nid)->execute()->fetchAll();
        if (!empty($data)) {
            $con->update('cache_clean')
                ->fields(array(
                    'nid' => $da->nid,
                    'school' => $da->title,
                    'domain' => $da->field_website_link_uri,
                    'status' => 0,
              ))
            ->condition('nid', $da->nid)
            ->execute();
        }
        else {
            $con->insert('cache_clean')
                ->fields(array(
                    'nid' => $da->nid,
                    'school' => $da->title,
                    'domain' => $da->field_website_link_uri,
                    'status' => 0,
              ))
            ->execute();
        }
    }
  
  }

}
