<?php
namespace Drupal\datashare\Controller;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\State\StateInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\media\Entity\Media;
use Drupal\file\Entity\File;
use Drupal\node\Entity\Node;
use Drupal\Core\Url;
use Drupal\Core\Render\Markup;

class DatashareController extends ControllerBase {
    /**
    * {@inheritdoc}
    */
    public function getData($type, $id) {
        $db = \Drupal::database();

        $data = $db->select('datashare_list','d')->fields('d')->condition('school_id', $id)->condition('type', $type)->execute()->fetchAll();
        
        foreach($data as $value) {
            $node_details = Node::load($value->nid);
            if (!empty($node_details)) {
                foreach ($node_details->getFields() as $name => $field) {
                    switch ($name) {
                      case "body":
                        $allFields[$name] = $node_details->get('body')->getValue()[0]['value'];
                        break;
                      case "field_alert_icon":
                        $term_name = \Drupal\taxonomy\Entity\Term::load($field->getString())->get('name')->value;
                        $allFields[$name] = $term_name;
                        break;
                      case "field_alert_type":
                        $term_name = \Drupal\taxonomy\Entity\Term::load($field->getString())->get('name')->value;
                        $allFields[$name] = $term_name;
                        break;
                      case "field_blog_type":
                        $term_name = \Drupal\taxonomy\Entity\Term::load($field->getString())->get('name')->value;
                        $allFields[$name] = $term_name;
                        break;
                      case "field_event":
                        $term_name = \Drupal\taxonomy\Entity\Term::load($field->getString())->get('name')->value;
                        $allFields[$name] = $term_name;
                        break;
                      case "field_news_type":
                        $term_name = \Drupal\taxonomy\Entity\Term::load($field->getString())->get('name')->value;
                        $allFields[$name] = $term_name;
                        break;
                      case "field_grades":
                        if (!empty($field->getString())) {
                            $term_name = \Drupal\taxonomy\Entity\Term::load($field->getString())->get('name')->value;
                        }
                        $allFields[$name] = $term_name;
                        break;
                      case "field_featured_image":
                        $file = \Drupal\file\Entity\File::load($node_details->get('field_featured_image')->getValue()[0]['target_id']);
                        
                        if (!empty($file)) {
                            $uri = $file->getFileUri();
                            $url = \Drupal\Core\Url::fromUri(file_create_url($uri))->toString();
                            $allFields[$name] = $url;
                        }
                        else {
                            $allFields[$name] = '';
                        }
                        break;
                      case "field_image_hero":
                        $file1 = $node_details->get('field_image_hero')->getValue()[0]['target_id'];
                        $media = Media::load($file1);
                        
                        $fid = $media->image->target_id;
                        $file2 = File::load($fid);
                        
                        if (!empty($file2)) {
                            $uri = $file2->getFileUri();
                            $url = \Drupal\Core\Url::fromUri(file_create_url($uri))->toString();
                            $allFields[$name] = $url;
                        }
                        else {
                            $allFields[$name] = '';
                        }
                        break;
                      case "field_data_desc":
                        $data = $node_details->get('field_data_desc')->getValue()[0]['value'];
                        $allFields[$name] = $data;
                        break;
                      case "field_school":
                        $sch_ids = $node_details->get('field_school')->getValue();
                        foreach ($sch_ids as $sch_id) {
                            $title = Node::load($sch_id['target_id'])->getTitle();
                            $allFields[$name] = $title;
                        }
                        
                        break;
                      case "field_datashare_slider":
                        $data1 = $node_details->get('field_datashare_slider')->getValue();
                        
                        if(!empty($data1)) {
                            $slide = [];
                            $i = '0';
                            foreach ($data1 as $val) {
                                $p = \Drupal\paragraphs\Entity\Paragraph::load( $val['target_id'] );
                                
                                $file = \Drupal\file\Entity\File::load($p->get('field_image')->getValue()[0]['target_id']);
                                if (!empty($file)) {
                                    $uri = $file->getFileUri();
                                    $url = \Drupal\Core\Url::fromUri(file_create_url($uri))->toString();
                                    $slide[$i]['url'] = $url;
                                }
                                $slide[$i]['text'] = $p->get('field_button_text')->getValue()[0]['value'];
                                $slide[$i]['description'] = $p->get('field_slide_description')->getValue()[0]['value'];
                                if(!empty($p->field_url[0]->uri)) {
                                    $mylink = Url::fromUri($p->field_url[0]->uri);
                                    $slide[$i]['link'] = $mylink->toString();
                                }
                                $slide[$i]['start_date'] = $p->get('field_start_date')->getValue()[0]['value'];
                                $slide[$i]['end_date'] = $p->get('field_end_date')->getValue()[0]['value'];
                                $i++;
                            }
                            $allFields[$name] = $slide;
                        }
                        break;
                      default:
                        $allFields[$name] = $field->getString();
                    }
                  
                  
                  
                }
            }
            $output[] = $allFields;
        } 
        return new JsonResponse([ 'data' => $output, 'method' => 'GET', 'status'=> 200]);
        dump($output); die;
    }
    
    public function getDataCalendar() {
        $config = \Drupal::config('yrdsb_workflows.settings');
        
        $output['data'] = $config->get('names_fieldset');
        $output['api_key'] = $config->get('google_calendar_api_key');
        return new JsonResponse([ 'data' => $output, 'method' => 'GET', 'status'=> 200]);
        dump($config); die;
    }
    
    public function image_category() {
        $vid = 'image_category';
        $terms =\Drupal::entityTypeManager()->getStorage('taxonomy_term')->loadTree($vid);
        
        foreach ($terms as $value) {
            $output[] = $value->name;
        }

        return new JsonResponse([ 'data' => $output, 'method' => 'GET', 'status'=> 200]);
        dump($config); die;
    }
    
    public function getEvents() {
        $query = \Drupal::database()->select('yrdsb_events', 'n')
            ->fields('n');
        $results = $query->execute()->fetchAll();
        
        return new JsonResponse([ 'data' => $results, 'method' => 'GET', 'status'=> 200]);
        dump($config); die;
    }
    
    public function content($type, $id) {
        echo $type; die;
        return new JsonResponse([ 'dataall' => $this->getData(), 'method' => 'GET', 'status'=> 200]);
    }
    public function getData1() {
        echo "test1"; die;
    $result=[];
    $nids = \Drupal::entityQuery('node')->accessCheck(TRUE)->condition('type','alert')->execute();  //content type added 
    $nodes =  \Drupal\node\Entity\Node::loadMultiple($nids);
    /***************Get all Nodes************************/
    foreach($nodes as $node){
       
        $sname = $node->get('field_school')->getValue();
      dump($node->get('nid'));  
        if(!$sanme){
            //echo '<pre>';
         //var_dump($sname);die;
             //echo '<pre>';//////
        }
        
    $result[] =[
    'data'=>  $node->get('nid')->getValue(),
    'data2'=>  $node->get('title')->getValue(),
    
    'forSchool'=>   $sname,
    //'Start Date'=>   $node->get('start_time')->getValue(),
    //'Start Date'=>   $node->get('end_time')->getValue(),
    
    //'data3'=>  $node->get('field_data_desc')->getValue(),
    //'heading'=>  $node->get('field_heading')->getValue(),
    //'type'=>  $node->get('field_type')->getValue(),
    //'field_start_time_date_end_time_d'=>  $node->get('field_start_time_date_end_time_d')->getValue(),
    //'field_selection'=>  $node->get('field_selection')->getValue(),
    //'field_attachment'=>  $node->get('field_attachment')->getValue(),
    ];
    }
    return $result;
    }
    public function sharemedia() {
    $ids = \Drupal::entityQuery('media')
    ->accessCheck(TRUE)
    ->condition('bundle', 'image')
    ->execute();
    $medias = Media::loadMultiple($ids);
    print_r($medias);
    dump($medias);
    return $medias;
    }
    public function contentall() {
        
        
        
        
        $result=[];
        $nids = \Drupal::entityQuery('node')->accessCheck(TRUE)->condition('type','schools')->execute();  //content type added 
        $nodes =  \Drupal\node\Entity\Node::loadMultiple($nids);
        /***************Get all Nodes************************/
        
        foreach($nodes as $node){
        global $base_url;
            
        $result[] =[
          $node->nid->value,
          $node->title->value,
        // $node->get('nid')->getValue(),
         //$node->get('title')->getValue(),
         Markup::create("<a href='".$base_url."/change_school_password?nid=".$node->nid->value."' class='use-ajax user_pass' data-dialog-options='{&quot;width&quot;:800}' data-dialog-type='modal'>Change Password</a>"),
        
        ];
        }
    
        if (isset($_GET['status']) && $_GET['status'] == 'success') {
            \Drupal::messenger()->addMessage('Password has been updated successfully.');
        }
        elseif(isset($_GET['status']) && $_GET['status'] == 'failed') {
            \Drupal::messenger()->addMessage('Password not updated due to some problem.');
        }
        
         $header = [
              'School id' => t('School id'),
              'School Name' => t('School name'),
              'Action' => t('Action')
            ];
            
            return [
              '#type' => 'table',
              '#header' => $header,
              '#rows' => $result,
            ];
    
    
    
    }
    
    
    public function contentalltypes() {
        
        
    //$entityTypeManager = \Drupal::service('entity_type.manager');
    $types = \Drupal::entityTypeManager()
      ->getStorage('node_type')
      ->loadMultiple();
    
    //$contentTypes = $entityTypeManager->getStorage('node_type')->loadMultiple();
    //$types=[];
    
    //foreach ($contentTypes as $contentType) {
      
     //$types[$contentType->id()] = $contentType->label();
    
    //}
    
    foreach ($types as $type) {
        
    $result[] =[
     
      $type->label(),
    // $node->get('nid')->getValue(),
     //$node->get('title')->getValue(),
     
    
    ];
    }
    
     $header = [
          
          'Content Type' => t('Content Type'),
        ];
        
        
    
           
        
        
        return [
          '#type' => 'table',
          '#header' => $header,
          '#rows' => $result,
        ];
    
        
    
           
        
        
        return $types;
    
    
        
        
        
    }

    
    public function getSchool($id) {
        $query = \Drupal::database()->select('node__field_school_id', 'n')
            ->fields('n')
            ->condition('n.field_school_id_value', $id);
        $results = $query->execute()->fetchAll();
        //dump($results); die;
        $node_details = Node::load($results['0']->entity_id);
            //dump($node_details); die;
            if (!empty($node_details)) {
                foreach ($node_details->getFields() as $name => $field) {
                    switch ($name) {
                      case "body":
                        //$allFields[$name] = $node_details->get('body')->getValue()[0]['value'];
                        $allFields[$name] = $node_details->body->value;
                        break;
                      case "field_tag":
                        $term_name = \Drupal\taxonomy\Entity\Term::load($field->getString())->get('name')->value;
                        $allFields[$name] = $term_name;
                        break;
                      case "field_address":
                        $address = $node_details->get('field_address')->getValue();
                        
                        $allFields['address_line1'] = $address[0]['address_line1'];
                        $allFields['locality'] = $address[0]['locality'];
                        $allFields['administrative_area'] = $address[0]['administrative_area'];
                        $allFields['postal_code'] = $address[0]['postal_code'];
                        break;
                      case "field_school_building_image":
                        $file = \Drupal\file\Entity\File::load($node_details->get('field_school_building_image')->getValue()[0]['target_id']);
                        
                        if (!empty($file)) {
                            $uri = $file->getFileUri();
                            $url = \Drupal\Core\Url::fromUri(\Drupal::service('file_url_generator')->generateAbsoluteString($uri))->toString();
                            $allFields[$name] = $url;
                        }
                        else {
                            $allFields[$name] = '';
                        }
                        break;
                      default:
                        $allFields[$name] = $field->getString();
                    }
                  
                  
                  
                }
            }
        return new JsonResponse([ 'data' => $allFields, 'method' => 'GET', 'status'=> 200]);
        dump($allFields); die;    
    }

    public function cta_dashboard_link () {
        $config = $this->config('yrdsb_dashboard.settings');
        $data = $config->get();
        return new JsonResponse([ 'data' => $data, 'method' => 'GET', 'status'=> 200]);
    }
}