<?php

namespace Drupal\datashare\Form;

/**
 * @file
 * Contains \Drupal\bifm\Form\ExchangeBook1.
 */

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Class ModalExample.
 *
 * @package Drupal\bifm\Form
 */
class ChangePassword extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'change_school_password';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

    $form['pass'] = [
      '#type' => 'password',
      '#title_display' => 'Password',
    ];

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => t('Save'),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $nid = $_GET['nid'];
    $node = \Drupal\node\Entity\Node::load($nid);
    $domain = $node->field_domain->value;
    
    if (!empty($domain)) {
        $password = base64_encode($form_state->getValue('pass'));
        
        $url = $domain . '/change_admin_password?token=eY277tJHGc3Cnm8gSMD4s^L^2Nv3SU!mJ3tO1kg@&pass=' . $password; 
        $response = new RedirectResponse($url);
        $response->send();
    }
    else {
        \Drupal::messenger()->addMessage('Domain is not specified for '.$node->getTitle().' school');
        global $base_url;
        $url = $base_url . '/allcontent';
        $response = new RedirectResponse($url);
        $response->send();
    }
    
  }

}
