<?php

/**
 * @file
 * Form template functions.
 */

use Drupal\Core\Form\FormStateInterface;

/**
 * Implements hook_preprocess_HOOK().
 */
function yrdsb_preprocess_form__views_exposed_form(&$variables) {
  if (isset($variables['attributes']['class'])) {
    $variables['attributes']['class'] = ['views-exposed-form'];
    if ($variables['element']['#context']['bef']) {
      $variables['attributes']['class'][] = ['bef-exposed-form'];
    }
  }
}

/**
 * Implements hook_preprocess_HOOK().
 */
function yrdsb_preprocess_bef_checkboxes(&$variables) {
  // Avoid displaying duplicate ids for checkboxes.
  $variables['attributes']['id'] = str_replace('--wrapper', '-bef--wrapper', $variables['attributes']['id']);
}

/**
 * Implements hook_preprocess_HOOK().
 */
function yrdsb_preprocess_bef_radios(&$variables) {
  // Avoid displaying duplicate ids for radios.
  $variables['attributes']['id'] = str_replace('--wrapper', '-bef--wrapper', $variables['attributes']['id']);
}

/**
 * Implements hook_preprocess_HOOK().
 */
function yrdsb_form_views_exposed_form_alter(&$form, FormStateInterface $form_state, $form_id) {
  if ($form_id == 'views_exposed_form') {
    $form['Keyword']['#attributes']['placeholder'] = t('Find resources, videos, news, events and more ...');
  }
}

/**
 * Implements theme_suggestions_form_alter()
 */
function yrdsb_theme_suggestions_form_alter(array &$suggestions, array $variables) {
  foreach ($variables['element']['#theme'] as $key => $value) {
    $suggestions[] = 'form__' . $value;
  }
}
