<?php

/**
 * @file
 * HTML template functions.
 */

use Drupal\file\Entity\File;
use Drupal\block\Entity\Block;

/**
 * Implements hook_preprocess_html().
 */
function yrdsb_preprocess_html(&$variables) {
  $variables['page']['#attached']['html_head'][] = [
    [
      '#tag' => 'meta',
      '#attributes' => [
        'http-equiv' => 'x-ua-compatible',
        'content' => 'ie=edge',
      ],
    ],
    'x_ua_compatible',
  ];

  // Add a language to the body.
  $variables['language'] = \Drupal::languageManager()->getCurrentLanguage()->getId();

  // Add node type class.
  $node = \Drupal::routeMatch()->getParameter('node');
  if ($node && is_array($node)) {
    $variables['attributes']['class'][] = 'path-node-' . $node->id();
  }

  // Add information about the number of sidebars to body.
  if (!empty(($variables['page']['sidebar_first'])) && !empty(($variables['page']['sidebar_second']))) {
    $variables['attributes']['class'][] = 'two-sidebars';
  }
  elseif (!empty(($variables['page']['sidebar_first']))) {
    $variables['attributes']['class'][] = 'one-sidebar';
    $variables['attributes']['class'][] = 'sidebar-first';
  }
  elseif (!empty(($variables['page']['sidebar_second']))) {
    $variables['attributes']['class'][] = 'one-sidebar';
    $variables['attributes']['class'][] = 'sidebar-second';
  }
  else {
    $variables['attributes']['class'][] = 'no-sidebars';
  }
}

/**
 * Implements hook_preprocess_block().
 *
 * If the variable exists set it to the variable link_var, the $vars variable is
 * set everywhere its where you can see what you have, and what you can use, we
 * are setting a variable inside it so it gets passed to the block template.
 */
function yrdsb_preprocess_block__system_branding_block(&$variables) {
  $variables['secondary_logo'] = theme_get_setting('secondary_logo');
  $variables['secondary_logo_mobile'] = theme_get_setting('secondary_logo_mobile');

  if (!empty($variables['secondary_logo'][0])) {
    $fid = $variables['secondary_logo'][0];
    $file = File::load($fid);

    if (!empty($file)) {
      $url = $file->url();
      $variables['secondary_logo']['file'] = $file;
      $variables['secondary_logo']['url'] = $url;
    }

  }
  if (!empty($variables['secondary_logo_mobile'][0])) {
    $fid = $variables['secondary_logo_mobile'][0];

    $file = File::load($fid);
    if (!empty($file)) {
      $url = $file->url();
      $variables['secondary_logo_mobile']['file'] = $file;
      $variables['secondary_logo_mobile']['url'] = $url;
    }
  }
  return $variables;

}

/**
 * Implements hook_preprocess_block().
 *
 * If the variable exists set it to the variable link_var, the $vars variable is
 * set everywhere its where you can see what you have, and what you can use, we
 * are setting a variable inside it so it gets passed to the block template.
 */
function yrdsb_preprocess_block__sitebranding_mobile(&$variables) {
  $variables['secondary_logo'] = theme_get_setting('secondary_logo');
  $variables['secondary_logo_mobile'] = theme_get_setting('secondary_logo_mobile');

  if (!empty($variables['secondary_logo'][0])) {
    $fid = $variables['secondary_logo'][0];

    $file = File::load($fid);
    if (!empty($file)) {
      $url = $file->url();
      $variables['secondary_logo']['file'] = $file;
      $variables['secondary_logo']['url'] = $url;
    }
  }
  if (!empty($variables['secondary_logo_mobile'][0])) {
    $fid = $variables['secondary_logo_mobile'][0];

    $file = File::load($fid);
    if (!empty($file)) {
      $url = $file->url();
      $variables['secondary_logo_mobile']['file'] = $file;
      $variables['secondary_logo_mobile']['url'] = $url;
    }

  }
  return $variables;
}

/**
 * Implements hook_preprocess_block().
 *
 * If the variable exists set it to the variable link_var, the $vars variable is
 * set everywhere its where you can see what you have, and what you can use, we
 * are setting a variable inside it so it gets passed to the block template.
 */
function yrdsb_preprocess_block(&$vars) {
  if (isset($vars['attributes']['id'])) {
    $vars['content']['#attributes']['block'] = $vars['attributes']['id'];
  }
  // Add block type class.
  $vars['current_language'] = \Drupal::languageManager()->getCurrentLanguage();
  $vars['theme_path'] = base_path() . $vars['directory'];

  if (isset($vars['elements']['#id'])) {
    $region = Block::load($vars['elements']['#id'])->getRegion();
    $vars['content']['#attributes']['region'] = $region;
  }

  if (!empty($vars['content']['#block_content'])) {
    // Get bundle/block type.
    $bundle = $vars['content']['#block_content']->bundle();

    // Set classname.
    $vars['attributes']['class'][] = 'block--' . str_replace('_', '-', $bundle);

    if ($bundle == 'call_out') {
      if (isset($vars['content']['field_link']['0']['#url'])) {
        $vars['link_var'] = $vars['content']['field_link']['0']['#url'];

        // We now unset the field link so it doesnt show up with the label.
        unset($vars['content']['field_link']);
      }
    }
  }
}
