<?php

/**
 * @file
 * Functions to support theming.
 */

/**
 * Implements hook_theme_suggestions_HOOK_alter().
 */
function yrdsb_theme_suggestions_page_alter(array &$suggestions, array $variables) {
  // $node = \Drupal::routeMatch()->getParameter('node');
  // if ($node && is_array($node)) {
  $request = \Drupal::request();
  $request_attributes = $request->attributes;
  if ($request_attributes->has('node') && $request_attributes->get('_route') === 'entity.node.canonical') {
    $node = $request_attributes->get('node');
    $content_type = $node->bundle();
    $suggestions[] = 'page__' . $content_type;
  }
  if ($view = \Drupal::routeMatch()->getParameter('view_id')) {
    if ($view !== "pantheon-solr-search") {
      $suggestions[] = 'page__view';
    }
  }
}

/**
 * Implements hook_form_system_theme_settings_alter().
 */
function yrdsb_form_system_theme_settings_alter(&$form, &$form_state, $form_id = NULL) {
  // Work-around for a core bug affecting admin themes. See issue #943212.
  if (isset($form_id)) {
    return;
  }

  $form['secondary_logo'] = [
    '#type' => 'managed_file',
    '#title' => t('Secondary Logo'),
    '#required' => FALSE,
    '#upload_location' => 'public://',
    '#default_value' => theme_get_setting('secondary_logo'),
    '#upload_validators' => [
      'file_validate_extensions' => ['svg'],
    ],
  ];

  $form['secondary_logo_mobile'] = [
    '#type' => 'managed_file',
    '#title' => t('Secondary Mobile Logo'),
    '#required' => FALSE,
    '#upload_location' => 'public://',
    '#default_value' => theme_get_setting('secondary_logo_mobile'),
    '#upload_validators' => [
      'file_validate_extensions' => ['svg'],
    ],
  ];
}
