<?php

/**
 * @file
 * THEME template functions.
 */

use Drupal\block\Entity\Block;

/**
 * Implements hook_preprocess().
 *
 * The 'language' variable is supposed to be globally available in Twig
 * templates since Drupal 8.2, but sometimes it doesn't seem to work.
 * Force it here.
 */
function yrdsb_preprocess(&$variables, $hook) {
  $variables['language'] = \Drupal::languageManager()->getCurrentLanguage();
}

/**
 * Implements theme_suggestions_taxonomy_term_alter()
 */
function yrdsb_theme_suggestions_taxonomy_term_alter(array &$suggestions, array $variables) {
  $suggestions[] = 'taxonomy_term__' . $variables['elements']['name']['#bundle'] . '__' . $variables['elements']['#view_mode'];
}

/**
 * Implements hook_theme_suggestions_block_alter().
 */
function yrdsb_theme_suggestions_block_alter(array &$suggestions, array $variables, $hook) {
  if (!empty($variables['elements']['content']['#block_content'])) {
    // Creates template theme suggestion for custom block type.
    array_splice($suggestions, 1, 0, 'block__bundle__' . $variables['elements']['content']['#block_content']->bundle());
    // Get bundle/block type.
  }

  // Region suggestion for blocks in panels.
  if (isset($variables['elements']['#configuration']['region'])) {
    $region = $variables['elements']['#configuration']['region'];
    $suggestions[] = 'block__' . $region;
    if (isset($variables['elements']['#configuration']['provider'])) {
      $provider = $variables['elements']['#configuration']['provider'];
      $suggestions[] = 'block__' . $region . '__' . $provider;
    }
  }
  // Region suggestion for blocks in Drupal.
  if (isset($variables['elements']['#id'])) {
    if ($block = Block::load($variables["elements"]["#id"])) {
      $region = $block->getRegion();
      $suggestions[] = 'block__' . $region;
      $suggestions[] = 'block__' . $region . '__' . $variables['elements']['#base_plugin_id'];
      $suggestions[] = 'block__' . $region . '__' . $variables['elements']['#id'];
      $suggestions[] = 'block__' . $region . '__' . $variables['elements']['#base_plugin_id'] . '__' . $variables['elements']['#id'];
    }
  }
}

/**
 * Implements hook_theme_suggestions_block_alter().
 */
function yrdsb_preprocess_media(&$variables) {
  // Adding the media url to the variables.
  $variables['url'] = $variables['media']->toUrl();
}

/**
 * Implements hook_preprocess_user().
 */
function yrdsb_preprocess_user(&$variables) {
  // Adding the users url to the variables.
  $variables['user_link'] = $variables['user']->toUrl();
}

/**
 * Implements hook_theme_suggestions_user_alter().
 */
function yrdsb_theme_suggestions_user_alter(&$suggestions, $vars, $hook) {

  // Define the view mode.
  $mode = $vars['elements']['#view_mode'];

  // Create a theme hook suggestion which has the view mode name in it.
  $suggestions[] = 'user__' . $mode;
}

/**
 * Implements hook_theme_suggestions_HOOK_alter().
 */
function yrdsb_theme_suggestions_menu_alter(array &$suggestions, array $variables) {

  if (isset($variables['relative_menu_items_configuration'])) {
    $suggestions[] = 'menu__relative_menu';
    $suggestions[] = $variables['theme_hook_original'] . '__relative_menu';
  }

  if (isset($variables['attributes']['region'])) {
    if (isset($variables['relative_menu_items_configuration'])) {
      $suggestions[] = 'menu__' . $variables['menu_name'] . '__relative_menu__' . $variables['attributes']['region'];
    }
    $suggestions[] = 'menu__' . $variables['attributes']['region'];
    $suggestions[] = 'menu__' . $variables['menu_name'] . '__' . $variables['attributes']['region'];
  }

  if (isset($variables['attributes']['block'])) {
    $hook = str_replace(['block-', '-'], ['', '_'], $variables['attributes']['block']);
    $suggestions[] = $variables['theme_hook_original'] . '__' . $hook;
    if (isset($variables['relative_menu_items_configuration'])) {
      $suggestions[] = $variables['theme_hook_original'] . '__relative_menu__' . $hook;
    }
  }

  // Remove the block and replace dashes with underscores in the block ID to
  // use for the hook name.
  if (!empty($variables['elements']['content']['#block_content'])) {
    // Creates template theme suggestion for custom block type.
    array_splice($suggestions, 1, 0, 'block__bundle__' . $variables['elements']['content']['#block_content']->bundle());
    // Get bundle/block type.
  }
}

/**
 * Implements hook_preprocess_node().
 */
function yrdsb_preprocess_node(&$variables) {
  if ($variables['elements']['#node']->bundle() == 'blog') {
    $date_updated = $variables['node']->getChangedTime();
    $date = $variables['node']->getCreatedTime();
    $variables['date'] = \Drupal::service('date.formatter')->format($date, 'york_search');
    $variables['html_date'] = \Drupal::service('date.formatter')->format($date, 'html_date');
    $variables['updated'] = \Drupal::service('date.formatter')->format($date_updated, 'york_search');
    $variables['html_date_updated'] = \Drupal::service('date.formatter')->format($date_updated, 'html_date');

  }
}
