(function ($, Drupal, window, document) {
    'use strict';

    // Example of Drupal behavior loaded.
    Drupal.behaviors.alertsJS = {
        attach: function (context, settings) {
            if (typeof context['location'] !== 'undefined') { // Only fire on document load.

                //check if sidewide alert block exist on page
                if ($('.view--sitewide-alerts.view--display-block_1').length) {

                    //check if local stoage has node ids of the closed alerts
                    if (localStorage.getItem("closedAlerts")) {
                        $(JSON.parse(localStorage.getItem("closedAlerts"))).removeClass('alert-item-show');
                    }
                    $('.alert-item-show').show();

                    //on click X for each alert add its node id to local storage variable
                    $(".view--sitewide-alerts.view--display-block_1 .alert-close .alert-close-button").click(function () {
                        var alerts_closed = "";
                        if (localStorage.getItem("closedAlerts")) {
                            alerts_closed = ".view__row." + $(this).closest('.site-wide-alerts').attr('id') + "," + JSON.parse(localStorage.getItem("closedAlerts"));
                            $(this).closest('.site-wide-alerts').remove();
                        } else {
                            alerts_closed = ".view__row." + $(this).closest('.site-wide-alerts').attr('id');
                            $(this).closest('.site-wide-alerts').remove();
                        }
                        $(this).parent().parent().remove();
                        localStorage.setItem("closedAlerts", JSON.stringify(alerts_closed));
                    });
                }
            }
        }
    };

})(jQuery, Drupal, this, this.document);
