(function ($, Drupal, window, document) {
  'use strict';

  // Example of Drupal behavior loaded.
  Drupal.behaviors.cssGridIEFix = {
    attach: function (context, settings) {
      if (typeof context['location'] !== 'undefined') { // Only fire on document load.
        if (!!window.MSInputMethodContext && !!document.documentMode) {
          var gridChildren = $('.grid-ie-fix > *');
          var numRows = Math.ceil(gridChildren.length / 3);
          var numCols = Math.ceil(gridChildren.length / 3);

          var currentRow = 1;

          for (var row = 0; row < numRows; row++) {
            for (var col = 0; col <= numCols; col++) {
              var currentChild = $(gridChildren[currentRow + col - 1]);
              
              $(currentChild).css({
                'margin-right': '1rem',
                'margin-bottom': '1rem',
                'grid-row': (row + 1).toString(),
                'grid-column': (col + 1).toString()
              });
            }

            currentRow += 3;
          }
        }
      }
    }
  };

})(jQuery, Drupal, this, this.document);
