(function($, Drupal, window, document) {
    'use strict';
    // Example of Drupal behavior loaded.
    Drupal.behaviors.imageSliderJS = {
        attach: function (context, settings) {
            if (typeof context['location'] !== 'undefined') { // Only fire on document load.
                var slider = $('.slider');
                var progressBar = $('.progress');

                // Settings for desktop slides
                var settingsdesktop = {
                  slidesToShow: 5,
                  slidesToScroll: 1,
                  infinite: false,
                  speed: 400,
                  prevArrow: '<div class="carousel-control-prev icon-prev"><i class="fas fa-chevron-circle-left fa-lg"></i><span class="sr-only">Previous</span></div>',
                  nextArrow: '<div class="carousel-control-next icon-next"><i class="fas fa-chevron-circle-right fa-lg"></i><span class="sr-only">Next</span></div>'

                }
                // Settings for tablet slides
                var settingstablet = {
                  slidesToShow: 3,
                  slidesToScroll: 1,
                  infinite: false,
                  initialSlide: 1,
                  speed: 400,
                  prevArrow: '<div class="carousel-control-prev icon-prev"><i class="fas fa-chevron-circle-left fa-lg"></i><span class="sr-only">Previous</span></div>',
                  nextArrow: '<div class="carousel-control-next icon-next"><i class="fas fa-chevron-circle-right fa-lg"></i><span class="sr-only">Next</span></div>'

                }
                // Settings for mobile slides
                var settingsmobile = {
                  slidesToShow: 1,
                  slidesToScroll: 1,
                  infinite: false,
                  speed: 200,
                  prevArrow: '<div class="carousel-control-prev icon-prev"><i class="fas fa-chevron-circle-left fa-lg"></i><span class="sr-only">Previous</span></div>',
                  nextArrow: '<div class="carousel-control-next icon-next"><i class="fas fa-chevron-circle-right fa-lg"></i><span class="sr-only">Next</span></div>'

                }
                /* Do this every time window gets resized */
                $(window).on('resize', function() {
                   /* If we are above mobile breakpoint unslick the slider */
                   if ($(window).width() >= 768) {
       // On arrow clicked will calculate current slide against total slide count

                     slider.on('beforeChange', function (event, slick, currentSlide, nextSlide) {
                         var current = slick.currentSlide + 5;
                         var total = slick.slideCount;
                         var divide = current / total;
                         var calc = divide * 100;
                         var size = Math.floor(calc);
                         progressBar.css('background-size', size + '% 100%').attr('aria-valuenow', size);
                     });

                     //On page load get current slide number and calculate against total slide count

                     slider.on('init reInit afterChange', function (event, slick, currentSlide, nextSlide) {
                       //currentSlide is undefined on init -- set it to 0 in this case (currentSlide is 0 based)
                         var current = slick.currentSlide + 5;
                         var total = slick.slideCount;
                         var divide = current / total;
                         var calc = divide * 100;
                         var size = Math.floor(calc);
                         progressBar.css('background-size', size + '% 100%').attr('aria-valuenow', size);

                     });
                      return slider.slick(settingsdesktop);
                   }
                   if ($(window).width() >= 400) {

                      // On arrow clicked will calculate current slide against total slide count

                      slider.on('beforeChange', function (event, slick, currentSlide, nextSlide) {
                          var current = slick.currentSlide + 3;
                          var total = slick.slideCount;
                          var divide = current / total;
                          var calc = divide * 100;
                          var size = Math.floor(calc);
                          progressBar.css('background-size', size + '% 100%').attr('aria-valuenow', size);
                      });

                      //On page load get current slide number and calculate against total slide count

                      slider.on('init reInit afterChange', function (event, slick, currentSlide, nextSlide) {
                        //currentSlide is undefined on init -- set it to 0 in this case (currentSlide is 0 based)
                          var current = slick.currentSlide + 3;
                          var total = slick.slideCount;
                          var divide = current / total;
                          var calc = divide * 100;
                          var size = Math.floor(calc);
                          progressBar.css('background-size', size + '% 100%').attr('aria-valuenow', size);

                      });
                      return slider.slick(settingstablet);
                   }
                   /* We are below mobile breakpoint, initialize the slider
                      if it is not already initialized */
                   else if (!slider.hasClass('slick-initialized')) {

                     // On arrow clicked will calculate current slide against total slide count

                     slider.on('beforeChange', function (event, slick, currentSlide, nextSlide) {
                         var current = slick.currentSlide + 1;
                         var total = slick.slideCount;
                         var divide = current / total;
                         var calc = divide * 100;
                         var size = Math.floor(calc);
                         progressBar.css('background-size', size + '% 100%').attr('aria-valuenow', size);
                     });

                     //On page load get current slide number and calculate against total slide count

                     slider.on('init reInit afterChange', function (event, slick, currentSlide, nextSlide) {
                       //currentSlide is undefined on init -- set it to 0 in this case (currentSlide is 0 based)
                         var current = slick.currentSlide + 1;
                         var total = slick.slideCount;
                         var divide = current / total;
                         var calc = divide * 100;
                         var size = Math.floor(calc);
                         progressBar.css('background-size', size + '% 100%').attr('aria-valuenow', size);

                     });
                     return slider.slick(settingsmobile);

                   }
                });
                $(window).trigger('resize');
              }
            }
          };
          $('#exampleModal').on('shown.bs.modal', function () {
              var bLazy = new Blazy();
            })

})(jQuery, Drupal, this, this.document);
