(function ($, Drupal, window, document) {
    'use strict';

    // Example of Drupal behavior loaded.
    Drupal.behaviors.themeJS = {
        attach: function (context, settings) {
            if (typeof context['location'] !== 'undefined') { // Only fire on document load.
                //
                $('.view--latest-news.view--display-block_3 ul.nav-tabs li:first a').addClass('active');
                $('.view--latest-news.view--display-block_1 .tab-content div.tab-pane:first').addClass('active show');
                $('.block__content').find('table').attr('data-tablesaw-mode', 'stack');

                // Adds lightbox to sections #photos
                $("section#photos .media > a").attr("data-toggle", "lightbox");
                $("section#photos .media > a").attr("data-gallery", "gallery");
                $("section#photos .media img").addClass('img-fluid');
                $(document).on("click", '[data-toggle="lightbox"]', function (event) {
                    event.preventDefault();
                    $(this).ekkoLightbox();
                });

                //Start - Remove description from Email subscription block on submitting it
                $('.paragraph--type-webforms .webforms-para-webform form .form-actions.webform-actions .webform-button--submit').click(function () {
                    setTimeout(function () {
                        $('.paragraph--type-webforms .webforms-para-title , .paragraph--type-webforms .webforms-para-body').hide();
                    }, 500);
                });
                //End - Remove description from Email subscription block on submitting it


            }
        }
    };
    // Background needs to match height of sibling element. For styling.
    var upcoming_board_activities_height = $('.upcoming_board_activities .upcoming-board-container').height();
    $('.upcoming_board_activities .background').height(upcoming_board_activities_height);

    var tabbed_views_center_align_height = $('.paragraph--type-tabbed-views-center-aligned .field--name-field-view-tabbed').height();
    if ($(window).width() < 768) {
      $('.paragraph--type-tabbed-views-center-aligned .background-grey-container').height(tabbed_views_center_align_height + 96);
    } else {
      $('.paragraph--type-tabbed-views-center-aligned .background-grey-container').height(tabbed_views_center_align_height + 128);
    }

    var homepage_hero_slideshow_height = $('.paragraph--type-homepage-hero-slideshow img').height();
    $('.paragraph--type-homepage-hero-slideshow .background-gradient').height(homepage_hero_slideshow_height);
    // End of Background height


    //START: Calendar Events Mobile View
    if ($(window).width() < 968) {
        jQuery(function () {
            jQuery('.fc-listYear-button').click();
        });
    }
    //END: Calendar Events Mobile View

    // Toggle dropdown button
    // Events listings
    $('.form-item--id-field-start-time-date-end-time-d-value-min input').click(function () {
        $('.form-item--id-field-start-time-date-end-time-d-value-min').addClass('clicked');
    })
    $('.form-item--id-field-start-time-date-end-time-d-value-min input').focusout(function () {
        $('.form-item--id-field-start-time-date-end-time-d-value-min').removeClass('clicked');
    })
    $('.form-item--id-field-start-time-date-end-time-d-value-max input').click(function () {
        $('.form-item--id-field-start-time-date-end-time-d-value-max').addClass('clicked');
    })
    $('.form-item--id-field-start-time-date-end-time-d-value-max input').focusout(function () {
        $('.form-item--id-field-start-time-date-end-time-d-value-max').removeClass('clicked');
    })

    // Webforms
    $('.paragraph--type-forms .form-item--date input').click(function () {
        $('.paragraph--type-forms .form-item--date').addClass('clicked');
    })
    $('.paragraph--type-forms .form-item--date input').focusout(function () {
        $('.paragraph--type-forms .form-item--date').removeClass('clicked');
    })
    $('.paragraph--type-forms .form-item--webform-time input').click(function () {
        $('.paragraph--type-forms .form-item--webform-time').addClass('clicked');
    })
    $('.paragraph--type-forms .form-item--webform-time input').focusout(function () {
        $('.paragraph--type-forms .form-item--webform-time').removeClass('clicked');
    })
    $('.paragraph--type-forms .form-item--select input').click(function () {
        $('.paragraph--type-forms .form-item--select').addClass('clicked');
    })
    $('.paragraph--type-forms .form-item--select input').focusout(function () {
        $('.paragraph--type-forms .form-item--select').removeClass('clicked');
    })
    // End toggle dropdown

    // Webform toggle switch
    $('.form-item--webform-toggle input').detach().appendTo('.form-item--webform-toggle .form-item__label');
    $('.form-item--webform-toggle span').detach().appendTo('.form-item--webform-toggle .form-item__label');
    $('.form-item--webform-toggle span').click(function () {
        if ($('.form-item--webform-toggle .toggle-on-label').hasClass('checked')) {
            $('.form-item--webform-toggle .toggle-on-label').removeClass('checked');
        } else {
            $('.form-item--webform-toggle .toggle-on-label').addClass('checked');
        }
        if ($('.form-item--webform-toggle .toggle-off-label').hasClass('unchecked')) {
            $('.form-item--webform-toggle .toggle-off-label').removeClass('unchecked');
        } else {
            $('.form-item--webform-toggle .toggle-off-label').addClass('unchecked');
        }
    })
    // End webform toggle switch

})(jQuery, Drupal, this, this.document);
