(function ($, Drupal, window, document) {
  'use strict';

  // Example of Drupal behavior loaded.
  Drupal.behaviors.stdContactForm = {
    attach: function (context, settings) {
      if (typeof context['location'] !== 'undefined') { // Only fire on document load.

        // Contact button click functionality
        $('.staff-listing--contact-btn[data-name][data-email][data-job-title][data-telephone]').click(function (e) {
          $('#edit-staff-name h3').text($(e.target).attr('data-name'));
          $('#edit-staff-position').text($(e.target).attr('data-job-title'));
          $('#edit-staff-visible-email').text($(e.target).attr('data-email'));
          $('#edit-staff-telephone').text($(e.target).attr('data-telephone'));
          $('.webform-submission-senior-team-directory-contact-form input[name="staff_email"][type="hidden"]').val($(e.target).attr('data-email'));
        });

        // Style the thank you modal
        if( $("#thisProfileConfirmation").length )
        {
          $(window).on('load',function(){
            var thankYou = $('#thisProfileConfirmation');
            $('#thisProfileConfirmation').remove();
            $('.dialog-off-canvas-main-canvas').append(thankYou);
            $('#thisProfileConfirmation').modal('show');
            $('header, main').addClass('opacity-25');

            setTimeout(function() {
              $('#thisProfileConfirmation').modal('hide');
              $('header, main').removeClass('opacity-25');
            }, 2000);
          });
        }

      }
    }
  };

})(jQuery, Drupal, this, this.document);
