(function($, Drupal, window, document) {
    'use strict';
    // Example of Drupal behavior loaded.
    Drupal.behaviors.tabbing = {
        attach: function(context, settings) {
            if (typeof context['location'] !== 'undefined') { // Only fire on document load.
                // Start - tabs
                if ($('.paragraph.paragraph--type-tabs .paragraph--type-tab--container').length > 0) {
                    $('.paragraph.paragraph--type-tabs .paragraph--type-tab--container .paragraph--type-tabs--nav div').remove();
                    //$('.paragraph.paragraph--type-tabs .paragraph--type-tab--container .paragraph--type-tab--content li').remove();
                    //Select the first tab
                    $('.paragraph.paragraph--type-tabs .paragraph--type-tab--container .paragraph--type-tabs--nav li:first a').addClass('active');
                    $('.paragraph.paragraph--type-tabs .paragraph--type-tab--container .paragraph--type-tabs--nav li:first').addClass('li-active');
                    $('.paragraph.paragraph--type-tabs .paragraph--type-tab--container .paragraph--type-tab--content div.tab-pane:first').addClass('active show');
                    //Add active class to li
                    $('.paragraph.paragraph--type-tabs .paragraph--type-tab--container .paragraph--type-tabs--nav li').click(function () {
                        $(".paragraph.paragraph--type-tabs .paragraph--type-tab--container .paragraph--type-tabs--nav li").removeClass('li-active active');
                        $(".paragraph.paragraph--type-tabs .paragraph--type-tab--container .paragraph--type-tabs--nav li a").removeClass('active');
                        $(this).addClass('li-active');
                    });
                }
                $('#viewTab a').on('click', function (e) {
                  e.preventDefault()
                  $(this).tab('show')
                })
                $('.paragraph--type-tabbed-views .nav-tabs .nav-link').click(function () {
                  $('.paragraph--type-tabbed-views .tab-content .tab-container').removeClass('active show');
                  var linkHref = $(this).attr('href').split('#');
                  console.log(linkHref[1]);
                  $('.paragraph--type-tabbed-views .tab-content .tab-container').find("#Principal's-Blog").addClass('active show');

                })
                // End - tabs

                // Start - newsroom tabs
                $('#newsroom-tabs li').on('click', function (e) {
                    e.preventDefault()
                    $(this).tab('show')
                })
                $('.node--type-newsroom .nav-tabs li').click(function () {
                    $('.node--type-newsroom .nav-tabs li').removeClass('active');
                    $(this).addClass('active');
                })
                // Newsroom sidebar region content
                // news is default to be open first
                $('.block--newsroom-news-sidebar').addClass(' active');
                $('.block--newsroom---news-post-content').addClass(' active');

                $('#news').click(function () {
                    if ($('#news').hasClass('active')) {
                        $('#events-tab').removeClass('active show');
                        $('.block--newsroom-news-sidebar').addClass(' active');
                        $('.block--newsroom---news-post-content').addClass('active');
                        $('.block--newsroom---videos-sidebar').removeClass('active');
                        $('.block--newsroom---events-sidebar').removeClass('active');
                        $('.block--newsroom---events-post-content').removeClass('active');
                        $('.block--newsroom---video-content').removeClass('active');
                    } else {
                        $('.block--newsroom-news-sidebar').removeClass('active');
                    }
                });
                // Tabbing Accessibility
                $('#news').keyup(function (event) {
                    if (event.keyCode === 13) { // Enter key pressed
                        $('#news').click();
                    }

                });
                $('#videos').click(function () {
                    if ($('#videos').hasClass('active')) {
                        $('#news-tab').removeClass('active show');
                        $('#events-tab').removeClass('active show');
                        $('.block--newsroom---videos-sidebar').addClass('active');
                        $('.block--newsroom---video-content').addClass('active');
                        $('.block--newsroom-news-sidebar').removeClass('active');
                        $('.block--newsroom---events-sidebar').removeClass('active');
                        $('.block--newsroom---news-post-content').removeClass('active');
                        $('.block--newsroom---events-post-content').removeClass('active');
                    } else {
                        $('.block--newsroom---videos-sidebar').removeClass('active');
                    }
                });
                // Tabbing Accessibility
                $('#videos').keyup(function (event) {
                    if (event.keyCode === 13) { // Enter key pressed
                        $('#videos').click();
                    }

                });
                $('#events').click(function () {
                    if ($('#events').hasClass('active')) {
                        $('#news-tab').removeClass('active show');
                        $('.block--newsroom---events-sidebar').addClass('active');
                        $('.block--newsroom---events-post-content').addClass('active');
                        $('.block--newsroom-news-sidebar').removeClass('active');
                        $('.block--newsroom---videos-sidebar').removeClass('active');
                        $('.block--newsroom---video-content').removeClass('active');
                        $('.block--newsroom---videos-sidebar').removeClass('active');
                        $('.block--newsroom---news-post-content').removeClass('active');
                    } else {
                        $('.block--newsroom---events-sidebar').removeClass('active');
                    }
                });
                // Tabbing Accessibility
                $('#events').keyup(function (event) {
                    if (event.keyCode === 13) { // Enter key pressed
                        $('#events').click();
                    }

                });
                // End - newsroom tabs

                //START: News listing tabs
                if ($(window).width() >= 768) {
                    if ($('.view--news-listing.view--display-block_1').length) {
                      //Select the first tab
                        $('.view--news-listing.view--display-block_1 h3:first a').addClass('active');
                        $('.view--news-listing.view--display-block_1 h3:first').addClass('h3-active');
                        $('.view--news-listing.view--display-page_1 .tab-content div.tab-pane:first').addClass('active show');
                        //Add active class to li
                        $(".view--news-listing.view--display-block_1 h3").click(function () {
                            $(".view--news-listing.view--display-block_1 h3 a").removeClass('active');
                            $(this).addClass('-active');
                        });
                    }
                } else {
                    if ($('.view--news-listing.view--display-block_1').length) {
                      //Select the first tab
                        $('.view--news-listing.view--display-block_1 h3 a').addClass('active');
                        $('.view--news-listing.view--display-block_1 h3').addClass('h3-active');
                        $('.view--news-listing.view--display-page_1 .tab-content div.tab-pane').addClass('active show');
                        //Add active class to li
                        $(".view--news-listing.view--display-block_1 h3").click(function () {
                            $(".view--news-listing.view--display-block_1 h3 a").removeClass('active');
                            $(this).addClass('-active');
                        });
                    }
                }
                //END: News listing tabs
            }
        }
    };
})(jQuery, Drupal, this, this.document);
