<?php
namespace Drupal\azure_login\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\State\StateInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\media\Entity\Media;
use Drupal\file\Entity\File;
use Drupal\node\Entity\Node;
use Drupal\user\Entity\User;

class AzureSso extends ControllerBase {
    private $httpHeaders = [];
    private $httpMethod = 'POST';
    
    private $cilentId;
    private $clientSecret;
    private $redirectUrl;
    
    private $isCommon = true;
    
    private $tenantID = 'common';
    
    private $enableAdminConsent = false;
    
    private $azureApiUrl;

    /**
    * {@inheritdoc}
    */
    private function http($url, $data = []){
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL,$url);
        
        if($this->httpHeaders){
            curl_setopt($ch, CURLOPT_HTTPHEADER,  $this->httpHeaders); 
        }

        if(strtoupper($this->httpMethod) == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
        }
        
        if($data) {
        curl_setopt($ch, CURLOPT_POSTFIELDS,http_build_query($data));
        }
        
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        $response = curl_exec($ch);
        
        curl_close($ch);
        
        return json_decode($response);
    }
    
    private function random_strings($length_of_string) {
    
        // String of all alphanumeric character
        $str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
    
        // Shuffle the $str_result and returns substring
        // of specified length
        return substr(str_shuffle($str_result), 0, $length_of_string);
    }
    
    public function content(){
        
        $config = \Drupal::config('azure_login_site_settings.settings');
        $clientid = $config->get('cilentId');
        $clientSecret = $config->get('clientSecret');
        $redirectUrl = $config->get('redirectUrl');
        $tenantID = $config->get('tenantID');
        $group_id = $config->get('group_id');
        $azureApiUrl = "https://login.microsoftonline.com/".$config->get('tenantID')."/oauth2";
    
        $code = $_GET['code'];
        $data = [
            'client_id' => $clientid,
            'scope' => 'user.read profile openid offline_access',
            'code' => $code,
            'redirect_uri' => $redirectUrl,
            'grant_type' => 'authorization_code',
            'client_secret' => $clientSecret,
            'prompt' => 'consent',
        ];
     
        $response = $this->http($azureApiUrl."/v2.0/token", $data);
        $output = $this->user($response->access_token);
        
        $output1 = $this->user1($response->access_token);
        foreach ($output1->value as $val) {
            $gid[] = $val->id;
        }
        
        if (!in_array($group_id, $gid)) {
            global $base_url;
            $response = new \Symfony\Component\HttpFoundation\RedirectResponse($base_url . '/profile_error');
              $request  = \Drupal::request();
              $request->getSession()->save();
              $response->prepare($request);
              \Drupal::service('kernel')->terminate($request, $response);
              $response->send();
        }

        $db = \Drupal\Core\Database\Database::getConnection();
		$query = $db->select('user__field_user_id', 'l');
		$query->fields('l', ['entity_id', 'field_user_id_value']);
		$query->condition('l.field_user_id_value', $output->id);
		$results = $query->execute()->fetchObject();
		
		$db = \Drupal\Core\Database\Database::getConnection();
		$query1 = $db->select('users_field_data', 'l');
		$query1->fields('l', ['uid', 'mail']);
		$query1->condition('l.mail', $output->mail);
		$results1 = $query1->execute()->fetchObject();
		if(empty($results) && !empty($results1)) {
		  $user = User::load($results1->uid);
          $user->set('mail', $output->mail);
          //$user->set('roles', ['yrdsb_content_contributor']);
          $user->set('field_user_id',  $output->id);
          $user->save();
          global $base_url;
          user_login_finalize($user);
          $response = new \Symfony\Component\HttpFoundation\RedirectResponse($base_url . '/user');
          $request  = \Drupal::request();
          $request->getSession()->save();
          $response->prepare($request);
          \Drupal::service('kernel')->terminate($request, $response);
          $response->send();
		}
        else if (!empty($results)) {
          $user = User::load($results->entity_id);
          $user->set('mail', $output->mail);
          //$user->set('roles', ['yrdsb_content_contributor']);
          $user->save();
          
          user_login_finalize($user);
          global $base_url;
          $response = new \Symfony\Component\HttpFoundation\RedirectResponse($base_url . '/user');
          $request  = \Drupal::request();
          $request->getSession()->save();
          $response->prepare($request);
          \Drupal::service('kernel')->terminate($request, $response);
          $response->send();
        }
        else {
        
            $user = User::create([
                'name' => $output->givenName,
                'mail' => $output->mail,
                'pass' => $config->get('default_password'),
                'status' => 1,
                //'roles' => array('yrdsb_content_contributor'),
                'field_user_id' => $output->id,
            ]);
        
            $user->save();
            
            user_login_finalize($user);
            global $base_url;
            $response = new \Symfony\Component\HttpFoundation\RedirectResponse($base_url . '/user');
              $request  = \Drupal::request();
              $request->getSession()->save();
              $response->prepare($request);
              \Drupal::service('kernel')->terminate($request, $response);
              $response->send();
        }
    
        dump($output); die;
    }
    
    public function user($token){
        
        $this->httpHeaders = ["Authorization: Bearer ".$token];
        
        $this->httpMethod = 'GET';
    
        return $this->http("https://graph.microsoft.com/v1.0/me");
    }
    
    public function user1($token){
        
        $this->httpHeaders = ["Authorization: Bearer ".$token];
        
        $this->httpMethod = 'GET';
    
        return $this->http("https://graph.microsoft.com/v1.0/me/transitiveMemberOf/microsoft.graph.group?$count=true");
    }

}